/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.internal.eunit.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eunit.EUnitModule;
import org.eclipse.epsilon.eunit.EUnitTest;
import org.eclipse.epsilon.eunit.EUnitTestResultType;
import org.eclipse.epsilon.internal.eunit.io.ByteBufferTeePrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EUnitXMLFormatter {
    private EUnitModule module;

    public EUnitXMLFormatter(EUnitModule module) {
        this.module = module;
    }

    public Document generate() throws EolRuntimeException {
        Document doc;
        try {
            doc = this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new EolInternalException(e);
        }
        Element suiteElem = doc.createElement("testsuite");
        doc.appendChild(suiteElem);
        List<EUnitTest> allTests = this.populateSuiteElement(doc, suiteElem);
        this.saveProperties(doc, suiteElem);
        for (EUnitTest test : allTests) {
            this.saveTestCase(doc, suiteElem, test);
        }
        this.saveOutput(doc, suiteElem, "system-out", (ByteBufferTeePrintStream)this.module.getContext().getOutputStream());
        this.saveOutput(doc, suiteElem, "system-err", (ByteBufferTeePrintStream)this.module.getContext().getErrorStream());
        return doc;
    }

    public void generate(File reportDirectory) throws EolRuntimeException {
        Document doc = this.generate();
        File reportFile = new File(reportDirectory, "TEST-" + this.module.getPackage() + "." + this.module.getClassName() + ".xml");
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            FileOutputStream osReport = new FileOutputStream(reportFile);
            try {
                transformer.transform(new DOMSource(doc), new StreamResult(osReport));
            }
            finally {
                osReport.close();
            }
        }
        catch (Exception e) {
            throw new EolInternalException(e);
        }
    }

    private Document createDocument() throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        return doc;
    }

    private void saveOutput(Document doc, Element suiteElem, String tagName, ByteBufferTeePrintStream bbStdout) {
        Element sysOutElem = doc.createElement(tagName);
        suiteElem.appendChild(sysOutElem);
        sysOutElem.setTextContent(new String(bbStdout.getBytes()));
    }

    private void saveTestCase(Document doc, Element suiteElem, EUnitTest test) {
        Element caseElem = doc.createElement("testcase");
        suiteElem.appendChild(caseElem);
        caseElem.setAttribute("classname", test.getQualifiedName(this.module.getPackage()));
        caseElem.setAttribute("name", test.getMethodName());
        caseElem.setAttribute("time", this.formatWallclockTime(test));
        Element resultChild = null;
        switch (test.getResult()) {
            case FAILURE: {
                resultChild = doc.createElement("failure");
                break;
            }
            case ERROR: {
                resultChild = doc.createElement("error");
            }
        }
        if (resultChild != null) {
            caseElem.appendChild(resultChild);
            resultChild.setAttribute("message", test.getException().getMessage());
            resultChild.setAttribute("type", test.getException().getClass().getName());
            StringWriter stringWriter = new StringWriter();
            test.getException().printStackTrace(new PrintWriter(stringWriter));
            resultChild.setTextContent(stringWriter.toString());
        }
    }

    private void saveProperties(Document doc, Element suiteElem) {
        Element propertiesElem = doc.createElement("properties");
        suiteElem.appendChild(propertiesElem);
        Properties sysProperties = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProperties.entrySet()) {
            Element propertyElem = doc.createElement("property");
            propertiesElem.appendChild(propertyElem);
            propertyElem.setAttribute("name", entry.getKey().toString());
            propertyElem.setAttribute("value", entry.getValue().toString());
        }
    }

    private List<EUnitTest> populateSuiteElement(Document doc, Element suiteElem) throws EolRuntimeException {
        EUnitTest root = this.module.getSuiteRoot();
        List selectedOperations = this.module.getSelectedOperations();
        List<EUnitTest> allTests = root.collectLeafTests(selectedOperations, null);
        List<EUnitTest> testsWithErrors = root.collectLeafTests(selectedOperations, EUnitTestResultType.ERROR);
        List<EUnitTest> testsWithFailures = root.collectLeafTests(selectedOperations, EUnitTestResultType.FAILURE);
        suiteElem.setAttribute("name", this.module.getQualifiedName());
        suiteElem.setAttribute("time", this.formatWallclockTime(root));
        suiteElem.setAttribute("tests", Integer.toString(allTests.size()));
        suiteElem.setAttribute("errors", Integer.toString(testsWithErrors.size()));
        suiteElem.setAttribute("failures", Integer.toString(testsWithFailures.size()));
        try {
            suiteElem.setAttribute("hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            suiteElem.setAttribute("hostname", "localhost");
        }
        return allTests;
    }

    private String formatWallclockTime(EUnitTest root) {
        return String.format(Locale.ENGLISH, "%g", (double)root.getWallclockTimeMillis() / 1000.0);
    }
}

