/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.epsilon.eol.execute.context.ExtendedProperties;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.workflow.tasks.transactions.NamedTransactionSupport;

public abstract class EpsilonTask
extends Task {
    static final String EPSILON_REPOSITORY = "epsilon.modelRepository";
    static final String EPSILON_EXTENDEDPROPERTIES = "epsilon.extendedProperties";
    static final String EPSILON_FRAME = "epsilon.frame";
    static final String EPSILON_ACTIVETRANSACTIONS = "epsilon.activeTransactions";
    protected boolean profile;
    protected boolean failOnErrors = true;
    protected boolean failOnWarnings = false;

    public final void execute() throws BuildException {
        this.executeImpl();
    }

    public abstract void executeImpl() throws BuildException;

    protected void fail(String message, Exception exception) throws BuildException {
        if (this.failOnErrors) {
            throw new BuildException(message, (Throwable)exception);
        }
        this.log(message, 0);
    }

    protected void warn(String message) throws BuildException {
        if (this.failOnWarnings) {
            throw new BuildException(message);
        }
        this.log(message, 1);
    }

    protected ExtendedProperties getExtendedProperties() {
        ExtendedProperties extendedProperties = (ExtendedProperties)this.getProject().getReference(EPSILON_EXTENDEDPROPERTIES);
        if (extendedProperties == null) {
            extendedProperties = new ExtendedProperties();
            this.getProject().addReference(EPSILON_EXTENDEDPROPERTIES, (Object)extendedProperties);
        }
        return extendedProperties;
    }

    protected ModelRepository getProjectRepository() {
        ModelRepository repository = (ModelRepository)this.getProject().getReference(EPSILON_REPOSITORY);
        if (repository == null) {
            repository = new ModelRepository();
            this.setProjectRepository(repository);
        }
        return repository;
    }

    protected void setProjectRepository(ModelRepository repository) {
        this.getProject().addReference(EPSILON_REPOSITORY, (Object)repository);
    }

    protected List<NamedTransactionSupport> getActiveTransactions() {
        ArrayList activeTransactions = (ArrayList)this.getProject().getReference(EPSILON_ACTIVETRANSACTIONS);
        if (activeTransactions == null) {
            activeTransactions = new ArrayList();
            this.getProject().addReference(EPSILON_ACTIVETRANSACTIONS, activeTransactions);
        }
        return activeTransactions;
    }

    protected Frame getProjectStackFrame() {
        Frame frame = (Frame)this.getProject().getReference(EPSILON_FRAME);
        if (frame == null) {
            frame = new SingleFrame(FrameType.PROTECTED, null);
            this.getProject().addReference(EPSILON_FRAME, (Object)frame);
        }
        return frame;
    }

    protected File getBaseDir() {
        return new File(this.getProject().getBaseDir(), "\\");
    }

    public boolean isProfile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isFailOnErrors() {
        return this.failOnErrors;
    }

    public void setFailOnErrors(boolean failOnErrors) {
        this.failOnErrors = failOnErrors;
    }

    public boolean isFailOnWarnings() {
        return this.failOnWarnings;
    }

    public void setFailOnWarnings(boolean failOnWarnings) {
        this.failOnWarnings = failOnWarnings;
    }
}

