/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.EolSystem;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IReflectiveModel;
import org.eclipse.epsilon.eol.models.ModelReference;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.models.ReflectiveModelReference;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.profiling.FileMarker;
import org.eclipse.epsilon.profiling.Profiler;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;
import org.eclipse.epsilon.workflow.tasks.hosts.HostManager;
import org.eclipse.epsilon.workflow.tasks.nestedelements.ModelNestedElement;
import org.eclipse.epsilon.workflow.tasks.nestedelements.ParameterNestedElement;
import org.eclipse.epsilon.workflow.tasks.nestedelements.VariableNestedElement;

public abstract class ExecutableModuleTask
extends EpsilonTask {
    protected List<ModelNestedElement> modelNestedElements = new ArrayList<ModelNestedElement>();
    protected List<VariableNestedElement> usesVariableNestedElements = new ArrayList<VariableNestedElement>();
    protected List<VariableNestedElement> exportsVariableNestedElements = new ArrayList<VariableNestedElement>();
    protected List<ParameterNestedElement> parameterNestedElements = new ArrayList<ParameterNestedElement>();
    protected File src;
    protected String code = "";
    protected IEolExecutableModule module;
    protected boolean assertions = true;
    protected String uri;
    protected Object result;
    private boolean isGUI = true;
    private boolean isDebug = false;
    protected boolean setBeans = false;

    static {
        HostManager.getHost().initialise();
    }

    public ModelNestedElement createModel() {
        ModelNestedElement model = new ModelNestedElement();
        this.modelNestedElements.add(model);
        return model;
    }

    public VariableNestedElement createUses() {
        VariableNestedElement variableNestedElement = new VariableNestedElement();
        this.usesVariableNestedElements.add(variableNestedElement);
        return variableNestedElement;
    }

    public VariableNestedElement createExports() {
        VariableNestedElement variableNestedElement = new VariableNestedElement();
        this.exportsVariableNestedElements.add(variableNestedElement);
        return variableNestedElement;
    }

    public ParameterNestedElement createParameter() {
        ParameterNestedElement parameterNestedElement = new ParameterNestedElement();
        this.parameterNestedElements.add(parameterNestedElement);
        return parameterNestedElement;
    }

    protected void configureModule() throws EolModelNotFoundException, BuildException, EolModelLoadingException {
        HostManager.getHost().addNativeTypeDelegates(this.module);
        HostManager.getHost().configureUserInput(this.module, this.isGUI());
        this.module.getContext().setExtendedProperties(this.getExtendedProperties());
        HostManager.getHost().addStopCapabilities(this.getProject(), this.module);
        EolSystem system = new EolSystem();
        system.setContext(this.module.getContext());
        this.module.getContext().setAssertionsEnabled(this.assertions);
        this.module.getContext().getFrameStack().put(Variable.createReadOnlyVariable("System", system));
        this.module.getContext().getFrameStack().put(Variable.createReadOnlyVariable("null", null));
        if (this.setBeans) {
            Project project = this.getProject();
            this.module.getContext().getFrameStack().put(Variable.createReadOnlyVariable("project", project));
            this.addVariables(this.module.getContext(), project.getProperties(), project.getUserProperties(), project.getCopyOfReferences(), project.getCopyOfTargets());
        }
        this.populateModelRepository(false);
        this.accessParameters();
        this.useVariables();
    }

    protected void addVariables(IEolContext context, Map<String, ?> ... variableMaps) {
        Map<String, ?>[] mapArray = variableMaps;
        int n = variableMaps.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, ?> variableMap = mapArray[n2];
            for (String key : variableMap.keySet()) {
                this.module.getContext().getFrameStack().put(Variable.createReadOnlyVariable(key, variableMap.get(key)));
            }
            ++n2;
        }
    }

    protected void useResults() throws Exception {
        this.exportVariables();
        this.examine();
    }

    protected void populateModelRepository(Boolean mustReload) throws EolModelNotFoundException, EolModelLoadingException {
        ModelRepository repository = this.module.getContext().getModelRepository();
        if (mustReload.booleanValue()) {
            repository.dispose();
        }
        ModelRepository projectRepository = this.getProjectRepository();
        for (ModelNestedElement modelNestedElement : this.modelNestedElements) {
            IModel model = projectRepository.getModelByName(modelNestedElement.getRef());
            if (mustReload.booleanValue()) {
                model.load();
            }
            ModelReference reference = this.createReference(model);
            if (modelNestedElement.getAs() != null) {
                reference.setName(modelNestedElement.getAs());
            }
            if (modelNestedElement.getAlias() != null) {
                reference.getAliases().addAll(StringUtil.split(modelNestedElement.getAlias(), ","));
            }
            repository.addModel(reference);
        }
    }

    private ModelReference createReference(IModel model) {
        if (model instanceof IReflectiveModel) {
            return new ReflectiveModelReference((IReflectiveModel)model);
        }
        return new ModelReference(model);
    }

    private void accessParameters() {
        for (ParameterNestedElement parameterNestedElement : this.parameterNestedElements) {
            this.module.getContext().getFrameStack().putGlobal(Variable.createReadOnlyVariable(parameterNestedElement.getName(), parameterNestedElement.getValue()));
        }
    }

    private void useVariables() throws BuildException {
        for (VariableNestedElement usesVariableNestedElement : this.usesVariableNestedElements) {
            this.useVariable(usesVariableNestedElement.getRef(), usesVariableNestedElement.getAs(), usesVariableNestedElement.isOptional(), usesVariableNestedElement.isAnt());
        }
    }

    private void exportVariables() {
        for (VariableNestedElement exportVariableNestedElement : this.exportsVariableNestedElements) {
            this.exportVariable(exportVariableNestedElement.getRef(), exportVariableNestedElement.getAs(), exportVariableNestedElement.isOptional(), exportVariableNestedElement.isAnt());
        }
    }

    public String getTaskName() {
        if (this.src != null) {
            return String.valueOf(super.getTaskName()) + " - " + this.src.getName();
        }
        return super.getTaskName();
    }

    @Override
    public void executeImpl() throws BuildException {
        if (this.src != null && this.profile) {
            Profiler.INSTANCE.start(this.src.getName(), "", new FileMarker(this.src, 0, 0));
        }
        try {
            this.parseModule();
            this.configureModule();
            this.initialize();
            if (!this.isDebug() || !HostManager.getHost().supportsDebugging()) {
                this.result = this.module.execute();
            } else {
                HostManager.getHost().debug(this.module, this.getSrc());
            }
            this.useResults();
            if (this.src != null && this.profile) {
                Profiler.INSTANCE.stop(this.src.getName());
            }
        }
        catch (Throwable t) {
            if (this.profile) {
                Profiler.INSTANCE.stop(this.src.getName());
            }
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.log("EXCEPTION: " + sw.toString(), 0);
            throw new BuildException(t);
        }
    }

    private void parseModule() throws Exception {
        this.module = this.createModule();
        if (this.src != null) {
            this.module.parse(this.src);
        } else if (this.uri != null) {
            this.module.parse(URI.create(this.uri));
        } else {
            this.module.parse(this.code);
        }
        if (this.module.getParseProblems().size() > 0) {
            for (ParseProblem problem : this.module.getParseProblems()) {
                this.log(problem.toString(), 0);
            }
        }
    }

    public void addText(String msg) {
        if (msg != null) {
            this.code = String.valueOf(this.code) + this.getProject().replaceProperties(msg);
        }
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File src) {
        this.src = src;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isAssertions() {
        return this.assertions;
    }

    public void setAssertions(boolean assertions) {
        this.assertions = assertions;
    }

    public void setGUI(boolean gui) {
        this.isGUI = gui;
    }

    public boolean isGUI() {
        return this.isGUI;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    protected void useVariable(String var, String as, boolean optional, boolean ant) {
        Object value;
        Variable usedVariable = null;
        usedVariable = ant ? new Variable(var, this.getProject().getProperty(var), EolPrimitiveType.String) : this.getProjectStackFrame().get(var);
        if (usedVariable != null && (value = usedVariable.getValue()) instanceof IModel) {
            IModel model = (IModel)value;
            ModelReference reference = this.createReference(model);
            if (as != null) {
                reference.setName(as);
            } else {
                reference.setName(var);
            }
            this.module.getContext().getModelRepository().addModel(reference);
            return;
        }
        if (usedVariable == null && this.getProject().getProperty(var) != null) {
            usedVariable = new Variable(var, this.getProject().getProperty(var), EolPrimitiveType.String);
        }
        if (usedVariable == null && !optional) {
            throw new BuildException("Undefined variable " + var);
        }
        if (as != null) {
            usedVariable.setName(as);
        }
        this.module.getContext().getFrameStack().putGlobal(usedVariable);
    }

    protected void exportVariable(String var, String as, boolean optional, boolean ant) {
        IModel model;
        Variable exportedVariable = this.module.getContext().getFrameStack().get(var);
        if (exportedVariable == null && (model = this.module.getContext().getModelRepository().getModelByNameSafe(var)) != null) {
            exportedVariable = Variable.createReadOnlyVariable(var, model);
        }
        if (exportedVariable != null) {
            if (as != null) {
                exportedVariable.setName(as);
            }
            if (ant) {
                this.getProject().setProperty(exportedVariable.getName(), this.module.getContext().getPrettyPrinterManager().print(exportedVariable.getValue()));
            } else {
                this.getProjectStackFrame().put(exportedVariable);
            }
        } else if (!optional) {
            throw new BuildException("Variable " + var + " is undefined");
        }
    }

    public void setSetBeans(boolean setBeans) {
        this.setBeans = setBeans;
    }

    public boolean isSetBeans() {
        return this.setBeans;
    }

    protected abstract void initialize() throws Exception;

    protected abstract void examine() throws Exception;

    protected abstract IEolExecutableModule createModule() throws Exception;
}

