/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks.emf;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.xml.XmlModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;
import org.eclipse.epsilon.workflow.tasks.ShutdownProjectRepositoryListener;

public class LoadXmlModelTask
extends EpsilonTask {
    protected String name;
    protected String aliases;
    protected File modelFile;
    protected File xsdFile;
    protected boolean read = true;
    protected boolean store = false;
    protected boolean expand = false;

    @Override
    public void executeImpl() throws BuildException {
        ShutdownProjectRepositoryListener.activate(this.getProject(), this.getProjectRepository());
        StringProperties properties = new StringProperties();
        properties.put("name", String.valueOf(this.name));
        properties.put("aliases", String.valueOf(this.aliases));
        properties.put(XmlModel.PROPERTY_MODEL_FILE, this.modelFile.getAbsolutePath());
        properties.put(XmlModel.PROPERTY_XSD_FILE, this.xsdFile.getAbsolutePath());
        properties.put("readOnLoad", String.valueOf(this.read));
        properties.put("storeOnDisposal", String.valueOf(this.store));
        properties.put("expand", String.valueOf(this.expand));
        try {
            XmlModel model = new XmlModel();
            model.load(properties, null);
            this.getProjectRepository().addModel(model);
        }
        catch (EolModelLoadingException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAliases() {
        return this.aliases;
    }

    public void setAliases(String aliases) {
        this.aliases = aliases;
    }

    public File getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(File modelFile) {
        this.modelFile = modelFile;
    }

    public File getXsdFile() {
        return this.xsdFile;
    }

    public void setXsdFile(File xsdFile) {
        this.xsdFile = xsdFile;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isStore() {
        return this.store;
    }

    public void setStore(boolean store) {
        this.store = store;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }
}

