/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.common.util.DerivedSubsetEObjectEList;
import org.eclipse.uml2.common.util.UnionEObjectEList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierOperations
extends NamespaceOperations {
    protected static final int[] GENERAL_ESUPERSETS = new int[]{28};

    protected ClassifierOperations() {
    }

    public static boolean conformsTo(Classifier classifier, Type other) {
        return other instanceof Classifier && (classifier == other || classifier.allParents().contains(other));
    }

    public static boolean validateNoCyclesInGeneralization(Classifier classifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (classifier.allParents().contains(classifier)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 11, UMLPlugin.INSTANCE.getString("_UI_Classifier_NoCyclesInGeneralization_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier)), new Object[]{classifier}));
            }
        }
        return result;
    }

    public static boolean validateSpecializeType(Classifier classifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (Classifier parent : classifier.parents()) {
            if (classifier.maySpecializeType(parent)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 8, UMLPlugin.INSTANCE.getString("_UI_Classifier_SpecializeType_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier, parent)), new Object[]{classifier, parent}));
        }
        return result;
    }

    public static boolean validateMapsToGeneralizationSet(Classifier classifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateNonFinalParents(Classifier classifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static EList<Property> getAllAttributes(Classifier classifier) {
        UniqueEList.FastCompare<Property> allAttributes = new UniqueEList.FastCompare<Property>();
        for (Feature feature : classifier.allFeatures()) {
            if (!(feature instanceof Property)) continue;
            allAttributes.add((Property)feature);
        }
        return ECollections.unmodifiableEList(allAttributes);
    }

    public static EList<Operation> getOperations(Classifier classifier) {
        UniqueEList.FastCompare<Operation> operations = new UniqueEList.FastCompare<Operation>();
        for (Feature feature : classifier.getFeatures()) {
            if (!(feature instanceof Operation)) continue;
            operations.add((Operation)feature);
        }
        return ECollections.unmodifiableEList(operations);
    }

    public static EList<Operation> getAllOperations(Classifier classifier) {
        UniqueEList.FastCompare<Operation> allOperations = new UniqueEList.FastCompare<Operation>();
        for (Feature feature : classifier.allFeatures()) {
            if (!(feature instanceof Operation)) continue;
            allOperations.add((Operation)feature);
        }
        return ECollections.unmodifiableEList(allOperations);
    }

    public static Operation getOperation(Classifier classifier, String name, EList<String> parameterNames, EList<Type> parameterTypes) {
        return classifier.getOperation(name, parameterNames, parameterTypes, false);
    }

    public static Operation getOperation(Classifier classifier, String name, EList<String> parameterNames, EList<Type> parameterTypes, boolean ignoreCase) {
        block0: for (Operation operation : classifier.getOperations()) {
            if (name != null && (ignoreCase ? !name.equalsIgnoreCase(operation.getName()) : !name.equals(operation.getName()))) continue;
            EList<Parameter> ownedParameterList = operation.getOwnedParameters();
            int ownedParameterListSize = ownedParameterList.size();
            if (parameterNames != null && parameterNames.size() != ownedParameterListSize || parameterTypes != null && parameterTypes.size() != ownedParameterListSize) continue;
            int j = 0;
            while (j < ownedParameterListSize) {
                Parameter ownedParameter = (Parameter)ownedParameterList.get(j);
                if (parameterNames != null && (!ignoreCase ? !((String)parameterNames.get(j)).equals(ownedParameter.getName()) : !((String)parameterNames.get(j)).equalsIgnoreCase(ownedParameter.getName()))) continue block0;
                if (parameterTypes != null && !((Type)parameterTypes.get(j)).equals(ownedParameter.getType())) continue block0;
                ++j;
            }
            return operation;
        }
        return null;
    }

    public static EList<Interface> getUsedInterfaces(Classifier classifier) {
        return ClassifierOperations.directlyUsedInterfaces(classifier);
    }

    public static EList<Interface> getAllUsedInterfaces(Classifier classifier) {
        return ClassifierOperations.allUsedInterfaces(classifier);
    }

    public static boolean maySpecializeType(Classifier classifier, Classifier c) {
        return c.eClass().isSuperTypeOf(classifier.eClass());
    }

    public static EList<Classifier> getGenerals(Classifier classifier) {
        return new GeneralEList(Classifier.class, (InternalEObject)((Object)classifier), 27, GENERAL_ESUPERSETS);
    }

    public static EList<NamedElement> getInheritedMembers(Classifier classifier) {
        UniqueEList.FastCompare<NamedElement> inheritedMembers = new UniqueEList.FastCompare<NamedElement>();
        for (Classifier parent : classifier.parents()) {
            inheritedMembers.addAll(parent.inheritableMembers(classifier));
        }
        EList<NamedElement> inherit = classifier.inherit(inheritedMembers);
        return new UnionEObjectEList<NamedElement>((InternalEObject)((Object)classifier), UMLPackage.Literals.CLASSIFIER__INHERITED_MEMBER, inherit.size(), inherit.toArray());
    }

    public static EList<Feature> allFeatures(Classifier classifier) {
        UniqueEList.FastCompare<Feature> allFeatures = new UniqueEList.FastCompare<Feature>();
        for (NamedElement member : classifier.getMembers()) {
            if (!(member instanceof Feature)) continue;
            allFeatures.add((Feature)member);
        }
        return ECollections.unmodifiableEList(allFeatures);
    }

    public static EList<Classifier> parents(Classifier classifier) {
        UniqueEList.FastCompare<Classifier> parents = new UniqueEList.FastCompare<Classifier>();
        for (Generalization generalization : classifier.getGeneralizations()) {
            Classifier general = generalization.getGeneral();
            if (general == null) continue;
            parents.add(general);
        }
        return ECollections.unmodifiableEList(parents);
    }

    public static EList<Interface> directlyRealizedInterfaces(Classifier classifier) {
        return ECollections.unmodifiableEList(ClassifierOperations.directlyRealizedInterfaces(classifier, true));
    }

    protected static EList<Interface> directlyRealizedInterfaces(Classifier classifier, boolean resolve) {
        return ClassifierOperations.directlyRealizedInterfaces(classifier, resolve, new UniqueEList.FastCompare<Interface>());
    }

    protected static EList<Interface> directlyRealizedInterfaces(Classifier classifier, boolean resolve, EList<Interface> realizedInterfaces) {
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof Realization)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                realizedInterfaces.add((Interface)supplier);
            }
        }
        return realizedInterfaces;
    }

    public static EList<Interface> directlyUsedInterfaces(Classifier classifier) {
        return ECollections.unmodifiableEList(ClassifierOperations.directlyUsedInterfaces(classifier, true));
    }

    protected static EList<Interface> directlyUsedInterfaces(Classifier classifier, boolean resolve) {
        return ClassifierOperations.directlyUsedInterfaces(classifier, resolve, new UniqueEList.FastCompare<Interface>());
    }

    protected static EList<Interface> directlyUsedInterfaces(Classifier classifier, boolean resolve, EList<Interface> usedInterfaces) {
        for (Dependency clientDependency : classifier.getClientDependencies()) {
            if (!(clientDependency instanceof Usage)) continue;
            Iterator suppliers = resolve ? clientDependency.getSuppliers().iterator() : ((InternalEList)clientDependency.getSuppliers()).basicIterator();
            while (suppliers.hasNext()) {
                NamedElement supplier = (NamedElement)suppliers.next();
                if (!(supplier instanceof Interface)) continue;
                usedInterfaces.add((Interface)supplier);
            }
        }
        return usedInterfaces;
    }

    public static EList<Interface> allRealizedInterfaces(Classifier classifier) {
        return ClassifierOperations.allRealizedInterfaces(classifier, true, new UniqueEList.FastCompare<Interface>());
    }

    protected static EList<Interface> allRealizedInterfaces(Classifier classifier, boolean resolve, EList<Interface> allRealizedInterfaces) {
        ClassifierOperations.directlyRealizedInterfaces(classifier, resolve, allRealizedInterfaces);
        for (Classifier parent : classifier.allParents()) {
            ClassifierOperations.directlyRealizedInterfaces(parent, resolve, allRealizedInterfaces);
        }
        return allRealizedInterfaces;
    }

    public static EList<Interface> allUsedInterfaces(Classifier classifier) {
        return ClassifierOperations.allUsedInterfaces(classifier, true, new UniqueEList.FastCompare<Interface>());
    }

    protected static EList<Interface> allUsedInterfaces(Classifier classifier, boolean resolve, EList<Interface> allUsedInterfaces) {
        ClassifierOperations.directlyUsedInterfaces(classifier, resolve, allUsedInterfaces);
        for (Classifier parent : classifier.allParents()) {
            ClassifierOperations.directlyUsedInterfaces(parent, resolve, allUsedInterfaces);
        }
        return allUsedInterfaces;
    }

    public static boolean isSubstitutableFor(Classifier classifier, Classifier contract) {
        for (Substitution subsitution : classifier.getSubstitutions()) {
            if (subsitution.getContract() != contract) continue;
            return true;
        }
        return false;
    }

    public static EList<Property> allAttributes(Classifier classifier) {
        UniqueEList.FastCompare<Property> allAttributes = new UniqueEList.FastCompare<Property>(classifier.getAttributes());
        for (Classifier parent : classifier.parents()) {
            allAttributes.addAll(parent.allAttributes());
        }
        EList<NamedElement> members = classifier.getMembers();
        ListIterator attribute = allAttributes.listIterator();
        while (attribute.hasNext()) {
            if (members.contains(attribute.next())) continue;
            attribute.remove();
        }
        return ECollections.unmodifiableEList(allAttributes);
    }

    public static EList<StructuralFeature> allSlottableFeatures(Classifier classifier) {
        UniqueEList.FastCompare<NamedElement> allSlottableFeatures = new UniqueEList.FastCompare<NamedElement>();
        for (NamedElement member : classifier.getMembers()) {
            if (!(member instanceof StructuralFeature)) continue;
            allSlottableFeatures.add((StructuralFeature)member);
        }
        UniqueEList.FastCompare<NamedElement> parentAttributes = new UniqueEList.FastCompare<NamedElement>();
        for (Classifier parent : classifier.allParents()) {
            parentAttributes.addAll(parent.getAttributes());
        }
        allSlottableFeatures.addAll(ClassifierOperations.inherit(classifier, parentAttributes));
        return ECollections.unmodifiableEList(allSlottableFeatures);
    }

    public static EList<NamedElement> inheritableMembers(Classifier classifier, Classifier c) {
        UniqueEList.FastCompare<NamedElement> inheritableMembers = new UniqueEList.FastCompare<NamedElement>();
        if (c == classifier || !c.allParents().contains(classifier) || classifier.allParents().contains(c)) {
            return inheritableMembers;
        }
        for (NamedElement member : classifier.getMembers()) {
            if (!c.hasVisibilityOf(member)) continue;
            inheritableMembers.add(member);
        }
        return ECollections.unmodifiableEList(inheritableMembers);
    }

    public static boolean hasVisibilityOf(Classifier classifier, NamedElement n) {
        for (Classifier parent : classifier.allParents()) {
            if (parent == classifier || parent.allParents().contains(classifier) || !parent.getMembers().contains(n)) continue;
            return n.getVisibility() != VisibilityKind.PRIVATE_LITERAL;
        }
        return false;
    }

    public static EList<NamedElement> inherit(Classifier classifier, EList<NamedElement> inhs) {
        UniqueEList.FastCompare<NamedElement> inherit = new UniqueEList.FastCompare<NamedElement>();
        UniqueEList.FastCompare<RedefinableElement> redefinedElements = new UniqueEList.FastCompare<RedefinableElement>();
        for (NamedElement ownedMember : classifier.getOwnedMembers()) {
            if (!(ownedMember instanceof RedefinableElement)) continue;
            redefinedElements.addAll(((RedefinableElement)ownedMember).getRedefinedElements());
        }
        for (NamedElement inh : inhs) {
            if (redefinedElements.contains(inh)) continue;
            inherit.add(inh);
        }
        return ECollections.unmodifiableEList(inherit);
    }

    protected static EList<Classifier> allParents(Classifier classifier, EList<Classifier> allParents) {
        for (Classifier parent : classifier.parents()) {
            if (!allParents.add(parent)) continue;
            ClassifierOperations.allParents(parent, allParents);
        }
        return allParents;
    }

    public static EList<Classifier> allParents(Classifier classifier) {
        return ECollections.unmodifiableEList(ClassifierOperations.allParents(classifier, new UniqueEList.FastCompare<Classifier>()));
    }

    public static boolean isTemplate(Classifier classifier) {
        return classifier.getOwnedTemplateSignature() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GeneralEList
    extends DerivedSubsetEObjectEList<Object> {
        protected GeneralEList(Class<?> dataClass, InternalEObject owner, int featureID, int[] sourceFeatureIDs) {
            super(dataClass, owner, featureID, sourceFeatureIDs);
        }

        @Override
        public List<Object> basicList() {
            return new GeneralEList(this.dataClass, this.owner, this.featureID, this.sourceFeatureIDs){

                @Override
                public ListIterator<Object> listIterator(int index) {
                    return this.basicListIterator(index);
                }
            };
        }

        @Override
        protected boolean isIncluded(EStructuralFeature feature) {
            return false;
        }

        @Override
        protected Object derive(Object object) {
            return ((Generalization)object).getGeneral();
        }

        @Override
        protected Object validate(int index, Object object) {
            Generalization generalization = UMLFactory.eINSTANCE.createGeneralization();
            generalization.setGeneral((Classifier)super.validate(index, object));
            return generalization;
        }
    }
}

