/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.PackageOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileOperations
extends PackageOperations {
    protected ProfileOperations() {
    }

    public static boolean validateMetaclassReferenceNotSpecialized(Profile profile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        block0: for (Class referencedMetaclass : profile.getReferencedMetaclasses()) {
            TreeIterator allContents = ProfileOperations.getAllContents(profile, true, false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Package) || !ProfileOperations.containsSpecializations((Package)eObject, referencedMetaclass)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            for (Classifier parent : referencedMetaclass.allParents()) {
                if (!EcoreUtil.isAncestor(profile, (EObject)parent)) continue;
                result = false;
                continue block0;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 27, UMLPlugin.INSTANCE.getString("_UI_Profile_MetaclassReferenceNotSpecialized_diagnostic", ProfileOperations.getMessageSubstitutions(context, profile)), new Object[]{profile}));
        }
        return result;
    }

    public static boolean validateReferencesSameMetamodel(Profile profile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        UniqueEList.FastCompare<Model> metamodels = new UniqueEList.FastCompare<Model>(profile.getReferencedMetamodels());
        for (Class referencedMetaclass : profile.getReferencedMetaclasses()) {
            metamodels.add(referencedMetaclass.getModel());
        }
        if (metamodels.size() != 1) {
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 28, UMLPlugin.INSTANCE.getString("_UI_Profile_ReferencesSameMetamodel_diagnostic", ProfileOperations.getMessageSubstitutions(context, profile)), new Object[]{profile}));
            }
            return false;
        }
        return true;
    }

    public static EObject create(Profile profile, Classifier classifier) {
        ENamedElement definition = profile.getDefinition(classifier);
        if (definition instanceof EClass) {
            return EcoreUtil.create((EClass)definition);
        }
        throw new IllegalArgumentException(String.valueOf(classifier));
    }

    public static boolean isDefined(Profile profile) {
        return profile.getDefinition() != null;
    }

    public static EPackage define(Profile profile) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        options.put("INVARIANT_CONSTRAINTS", "IGNORE");
        options.put("OPERATION_BODIES", "IGNORE");
        options.put("PROPERTY_DEFAULT_EXPRESSIONS", "IGNORE");
        options.put("COMMENTS", "IGNORE");
        return profile.define(options, null, null);
    }

    public static EPackage define(Profile profile, Map<String, String> options, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EPackage definition;
        Collection<EPackage> ePackages = ProfileOperations.convertToEcore(profile, options, diagnostics, context);
        EPackage ePackage = definition = ePackages.size() == 1 ? ePackages.iterator().next() : null;
        if (definition != null) {
            ProfileOperations.getEAnnotation(profile, "http://www.eclipse.org/uml2/2.0.0/UML", true).getContents().add(0, definition);
        }
        return definition;
    }

    public static EPackage getDefinition(Profile profile) {
        EList<EObject> contents;
        EAnnotation eAnnotation;
        EPackage definition = ProfileOperations.getEPackage(profile);
        if (definition == null && (eAnnotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && (contents = eAnnotation.getContents()).size() > 0) {
            definition = (EPackage)contents.get(0);
        }
        return definition;
    }

    protected static ENamedElement getDefinition(Profile profile, NamedElement namedElement, EPackage profileDefinition) {
        if (namedElement instanceof Classifier) {
            ENamedElement packageDefinition = ProfileOperations.getDefinition(profile, ((Classifier)namedElement).getPackage(), profileDefinition);
            if (packageDefinition instanceof EPackage) {
                if (packageDefinition.eContainer() instanceof EAnnotation) {
                    for (EClassifier eClassifier : ((EPackage)packageDefinition).getEClassifiers()) {
                        EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
                        if (eAnnotation == null || !eAnnotation.getReferences().contains(namedElement)) continue;
                        return eClassifier;
                    }
                } else {
                    return ((EPackage)packageDefinition).getEClassifier(ProfileOperations.getEcoreName(namedElement));
                }
            }
            return null;
        }
        if (namedElement instanceof Property) {
            ENamedElement namespaceDefinition = ProfileOperations.getDefinition(profile, namedElement.getNamespace(), profileDefinition);
            return namespaceDefinition instanceof EClass ? ((EClass)namespaceDefinition).getEStructuralFeature(ProfileOperations.getEcoreName(namedElement)) : null;
        }
        if (namedElement instanceof EnumerationLiteral) {
            ENamedElement namespaceDefinition = ProfileOperations.getDefinition(profile, namedElement.getNamespace(), profileDefinition);
            return namespaceDefinition instanceof EEnum ? ((EEnum)namespaceDefinition).getEEnumLiteral(ProfileOperations.getEcoreName(namedElement)) : null;
        }
        if (namedElement instanceof Profile) {
            EAnnotation eAnnotation;
            if (namedElement != profile && (eAnnotation = profileDefinition.getEAnnotation("http://www.eclipse.org/uml2/4.1.0/UML")) != null) {
                for (EObject reference : eAnnotation.getReferences()) {
                    EPackage ePackage;
                    if (!(reference instanceof EPackage) || ProfileOperations.getProfile(ePackage = (EPackage)reference, profile) != namedElement) continue;
                    return ePackage;
                }
            }
            return profileDefinition;
        }
        if (namedElement instanceof Package) {
            ENamedElement packageDefinition = ProfileOperations.getDefinition(profile, ((Package)namedElement).getNestingPackage(), profileDefinition);
            if (packageDefinition instanceof EPackage) {
                if (profileDefinition.eContainer() instanceof EAnnotation) {
                    for (EPackage eSubpackage : ((EPackage)packageDefinition).getESubpackages()) {
                        EAnnotation eAnnotation = eSubpackage.getEAnnotation("http://www.eclipse.org/uml2/4.0.0/UML");
                        if (eAnnotation == null || !eAnnotation.getReferences().contains(namedElement)) continue;
                        return eSubpackage;
                    }
                } else {
                    String name = ProfileOperations.getEcoreName(namedElement);
                    for (EPackage eSubpackage : ((EPackage)packageDefinition).getESubpackages()) {
                        if (!ProfileOperations.safeEquals(eSubpackage.getName(), name)) continue;
                        return eSubpackage;
                    }
                }
            }
            return ProfileOperations.getDefinition(profile, ((Package)namedElement).containingProfile(), profileDefinition);
        }
        return null;
    }

    public static ENamedElement getDefinition(Profile profile, NamedElement namedElement) {
        return ProfileOperations.getDefinition(profile, namedElement, profile.getDefinition());
    }

    public static EList<Class> getReferencedMetaclasses(Profile profile) {
        UniqueEList.FastCompare<Class> referencedMetaclasses = new UniqueEList.FastCompare<Class>();
        for (ElementImport metaclassReference : profile.getMetaclassReferences()) {
            PackageableElement importedElement = metaclassReference.getImportedElement();
            if (!(importedElement instanceof Class)) continue;
            referencedMetaclasses.add((Class)importedElement);
        }
        return ECollections.unmodifiableEList(referencedMetaclasses);
    }

    public static EList<Model> getReferencedMetamodels(Profile profile) {
        UniqueEList.FastCompare<Model> referencedMetamodels = new UniqueEList.FastCompare<Model>();
        for (PackageImport metamodelReference : profile.getMetamodelReferences()) {
            Package importedPackage = metamodelReference.getImportedPackage();
            if (!(importedPackage instanceof Model)) continue;
            referencedMetamodels.add((Model)importedPackage);
        }
        return ECollections.unmodifiableEList(referencedMetamodels);
    }

    protected static EList<Extension> getOwnedExtensions(Profile profile, boolean requiredOnly, EList<Extension> ownedExtensions) {
        for (Extension extension : EcoreUtil.getObjectsByType(profile.getPackagedElements(), UMLPackage.Literals.EXTENSION)) {
            if (requiredOnly && !extension.isRequired()) continue;
            ownedExtensions.add(extension);
        }
        return ownedExtensions;
    }

    public static EList<Extension> getOwnedExtensions(Profile profile, boolean requiredOnly) {
        return ECollections.unmodifiableEList(ProfileOperations.getOwnedExtensions(profile, requiredOnly, new UniqueEList.FastCompare<Extension>()));
    }
}

