/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;
import org.eclipse.uml2.uml.internal.operations.RedefinableElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionOperations
extends NamespaceOperations {
    protected RegionOperations() {
    }

    public static boolean validateInitialVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int initialVertexCount = 0;
        for (Vertex subvertex : region.getSubvertices()) {
            if (!(subvertex instanceof Pseudostate) || ((Pseudostate)subvertex).getKind() != PseudostateKind.INITIAL_LITERAL) continue;
            ++initialVertexCount;
        }
        if (initialVertexCount > 1) {
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 109, UMLPlugin.INSTANCE.getString("_UI_Region_InitialVertex_diagnostic", RegionOperations.getMessageSubstitutions(context, region)), new Object[]{region}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateDeepHistoryVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int deepHistoryVertexCount = 0;
        for (Vertex subvertex : region.getSubvertices()) {
            if (!(subvertex instanceof Pseudostate) || ((Pseudostate)subvertex).getKind() != PseudostateKind.DEEP_HISTORY_LITERAL) continue;
            ++deepHistoryVertexCount;
        }
        if (deepHistoryVertexCount > 1) {
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 106, UMLPlugin.INSTANCE.getString("_UI_Region_DeepHistoryVertex_diagnostic", RegionOperations.getMessageSubstitutions(context, region)), new Object[]{region}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateShallowHistoryVertex(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int shallowHistoryVertexCount = 0;
        for (Vertex subvertex : region.getSubvertices()) {
            if (!(subvertex instanceof Pseudostate) || ((Pseudostate)subvertex).getKind() != PseudostateKind.SHALLOW_HISTORY_LITERAL) continue;
            ++shallowHistoryVertexCount;
        }
        if (shallowHistoryVertexCount > 1) {
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 107, UMLPlugin.INSTANCE.getString("_UI_Region_ShallowHistoryVertex_diagnostic", RegionOperations.getMessageSubstitutions(context, region)), new Object[]{region}));
            }
            return false;
        }
        return true;
    }

    public static boolean validateOwned(Region region, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (region.getStateMachine() != null && region.getState() != null) {
            if (diagnostics != null) {
                diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 108, UMLPlugin.INSTANCE.getString("_UI_Region_Owned_diagnostic", RegionOperations.getMessageSubstitutions(context, region)), new Object[]{region}));
            }
            return false;
        }
        return true;
    }

    public static Classifier redefinitionContext(Region region) {
        StateMachine sm = region.containingStateMachine();
        if (sm != null) {
            BehavioredClassifier context = sm.getContext();
            return context == null || !sm.getGenerals().isEmpty() ? sm : context;
        }
        return null;
    }

    public static StateMachine containingStateMachine(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine == null) {
            State state = region.getState();
            return state == null ? null : state.containingStateMachine();
        }
        return stateMachine;
    }

    public static boolean belongsToPSM(Region region) {
        StateMachine stateMachine = region.getStateMachine();
        if (stateMachine != null) {
            return stateMachine instanceof ProtocolStateMachine;
        }
        State state = region.getState();
        if (state != null) {
            Region container = state.getContainer();
            return container != null && container.belongsToPSM();
        }
        return false;
    }

    public static boolean isConsistentWith(Region region, RedefinableElement redefiningElement) {
        if (redefiningElement != null && redefiningElement.isRedefinitionContextValid(region)) {
            Region redefiningRegion = (Region)redefiningElement;
            EList<Vertex> allSubvertices = RegionOperations.getAllSubvertices(region);
            for (Vertex redefiningSubvertex : redefiningRegion.getSubvertices()) {
                State redefinedState;
                if (!(redefiningSubvertex instanceof State) || (redefinedState = ((State)redefiningSubvertex).getRedefinedState()) == null || allSubvertices.contains(redefinedState)) continue;
                return false;
            }
            EList<Transition> allTransitions = RegionOperations.getAllTransitions(region);
            for (Transition redefiningTransition : redefiningRegion.getTransitions()) {
                Transition redefinedTransition = redefiningTransition.getRedefinedTransition();
                if (redefinedTransition == null || allTransitions.contains(redefinedTransition)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRedefinitionContextValid(Region region, RedefinableElement redefinedElement) {
        if (redefinedElement instanceof Region) {
            StateMachine stateMachine = region.getStateMachine();
            if (stateMachine == null) {
                State redefinedState;
                State state = region.getState();
                State state2 = redefinedState = state == null ? null : state.getRedefinedState();
                return redefinedState != null && redefinedState.getRegions().contains(redefinedElement);
            }
            for (StateMachine extendedStateMachine : stateMachine.getExtendedStateMachines()) {
                if (!extendedStateMachine.getRegions().contains(redefinedElement)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected static EList<Region> getAllExtendedRegions(Region region, EList<Region> allExtendedRegions) {
        Region extendedRegion = region.getExtendedRegion();
        if (extendedRegion != null && allExtendedRegions.add(extendedRegion)) {
            RegionOperations.getAllExtendedRegions(extendedRegion, allExtendedRegions);
        }
        return allExtendedRegions;
    }

    protected static EList<Region> getAllExtendedRegions(Region region) {
        return RegionOperations.getAllExtendedRegions(region, new UniqueEList.FastCompare<Region>());
    }

    protected static EList<Vertex> getAllSubvertices(Region region) {
        UniqueEList.FastCompare<Vertex> allSubvertices = new UniqueEList.FastCompare<Vertex>(region.getSubvertices());
        for (Region extendedRegion : RegionOperations.getAllExtendedRegions(region)) {
            allSubvertices.addAll(extendedRegion.getSubvertices());
        }
        return RedefinableElementOperations.excludeRedefinedElements(allSubvertices);
    }

    protected static EList<Transition> getAllTransitions(Region region) {
        UniqueEList.FastCompare<Transition> allTransitions = new UniqueEList.FastCompare<Transition>(region.getTransitions());
        for (Region extendedRegion : RegionOperations.getAllExtendedRegions(region)) {
            allTransitions.addAll(extendedRegion.getTransitions());
        }
        return RedefinableElementOperations.excludeRedefinedElements(allTransitions);
    }
}

