/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.parse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.runtime.tree.Tree;
import org.eclipse.epsilon.common.parse.StaticFieldNameResolver;
import org.eclipse.epsilon.common.util.StringUtil;

public class Antlr3TreeViewer
extends JFrame {
    StaticFieldNameResolver v3Resolver;
    JTree v3Tree = new JTree();

    public Antlr3TreeViewer(Tree tree, Class<?> v3Parser) {
        this.v3Resolver = new StaticFieldNameResolver(v3Parser);
        this.v3Tree.setModel(new V3TreeModel(tree));
        this.v3Tree.setCellRenderer(new V3TreeCellRenderer());
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setRightComponent(new JScrollPane(this.v3Tree));
        splitPane.setDividerLocation(0.5);
        this.getContentPane().add((Component)splitPane, "Center");
        this.setTitle("AST Viewer");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 800, 800);
        this.setVisible(true);
    }

    public void expandAll(JTree tree) {
        int row = 0;
        while (row < tree.getRowCount()) {
            tree.expandRow(row);
            ++row;
        }
    }

    class V3TreeCellRenderer
    implements TreeCellRenderer {
        V3TreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree arg0, Object arg1, boolean selected, boolean expanded, boolean leaf, int row, boolean arg6) {
            JLabel label = new JLabel();
            Tree ast = (Tree)arg1;
            if (selected) {
                label.setOpaque(true);
                label.setBackground(SystemColor.activeCaption);
                label.setForeground(SystemColor.activeCaptionText);
            }
            label.setIcon(new ImageIcon(V3TreeCellRenderer.class.getResource("node.gif")));
            label.setText("<html>" + this.getText(ast) + " (" + Antlr3TreeViewer.this.v3Resolver.getField(ast.getType()) + "-" + ast.getType() + ")" + "<font color='#C0C0C0'>" + " (Line:" + ast.getLine() + ",Col:" + ast.getCharPositionInLine() + ")" + "</font>" + "</html>");
            return label;
        }

        private String getText(Tree ast) {
            String str = StringUtil.escapeHtml(ast.getText());
            str = str.replaceAll("\r", "<font color='#336699'>\\\\r</font>");
            str = str.replaceAll("\n", "<font color='#336699'>\\\\n</font>");
            str = str.replaceAll("\t", "<font color='#336699'>\\\\t</font>");
            return str;
        }
    }

    class V3TreeModel
    implements TreeModel {
        private Tree tree = null;

        public V3TreeModel(Tree tree) {
            this.tree = tree;
        }

        public Tree toTree(Object o) {
            return (Tree)o;
        }

        @Override
        public Object getRoot() {
            return this.tree;
        }

        @Override
        public Object getChild(Object arg0, int arg1) {
            Tree child = this.toTree(arg0);
            return child.getChild(arg1);
        }

        @Override
        public int getChildCount(Object arg0) {
            return this.toTree(arg0).getChildCount();
        }

        @Override
        public boolean isLeaf(Object arg0) {
            return this.toTree(arg0).getChildCount() == 0;
        }

        @Override
        public void valueForPathChanged(TreePath arg0, Object arg1) {
        }

        @Override
        public int getIndexOfChild(Object arg0, Object arg1) {
            return 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener arg0) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener arg0) {
        }
    }
}

