/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.merge.output.ProtectedRegion;
import org.eclipse.epsilon.egl.output.Writer;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;
import org.eclipse.epsilon.egl.traceability.OutputFile;
import org.eclipse.epsilon.egl.util.FileUtil;

public class EglFileGeneratingTemplate
extends EglPersistentTemplate {
    private File target;
    private String targetName;
    private OutputFile currentOutputFile;
    private String existingContents;
    private String newContents;
    private String positiveMessage;
    private OutputMode outputMode;

    protected EglFileGeneratingTemplate(URI path, IEglContext context, URI outputRoot) throws Exception {
        this(new EglTemplateSpecificationFactory(new NullFormatter(), new IncrementalitySettings(), new ITemplateExecutionListener[0]).fromResource(path.toString(), path), context, outputRoot, outputRoot.getPath());
    }

    public EglFileGeneratingTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot, String outputRootPath) throws Exception {
        super(spec, context, outputRoot, outputRootPath);
    }

    public void append(String path) throws EglRuntimeException {
        try {
            File target = this.resolveFile(path);
            if (!this.isProcessed()) {
                this.process();
            }
            this.target = target;
            this.targetName = this.name(path);
            this.existingContents = FileUtil.readIfExists(target);
            this.outputMode = OutputMode.APPEND;
            this.prepareNewContents();
            this.writeNewContentsIfDifferentFromExistingContents();
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + this.target, e, this.module.getAst());
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not generate to: " + this.target, ex, this.module.getAst());
        }
    }

    @Override
    protected void doGenerate(File target, String targetName, boolean overwrite, boolean protectRegions) throws EglRuntimeException {
        try {
            this.target = target;
            this.targetName = targetName;
            this.existingContents = FileUtil.readIfExists(target);
            this.outputMode = protectRegions && target.exists() ? OutputMode.MERGE : OutputMode.WRITE;
            this.prepareNewContents();
            this.writeNewContentsIfDifferentFromExistingContents();
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + target, e, this.module.getAst());
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not generate to: " + target, ex, this.module.getAst());
        }
    }

    private void prepareNewContents() throws EglRuntimeException {
        switch (this.outputMode) {
            case APPEND: {
                this.newContents = String.valueOf(this.existingContents) + FileUtil.NEWLINE + this.getContents();
                this.positiveMessage = "Successfully appended to ";
                break;
            }
            case MERGE: {
                this.newContents = this.merge(this.existingContents);
                this.positiveMessage = "Protected regions preserved in ";
                break;
            }
            case WRITE: {
                this.newContents = this.getContents();
                this.positiveMessage = "Successfully wrote to ";
                break;
            }
            default: {
                throw new EglRuntimeException("Unsupported output mode " + (Object)((Object)this.outputMode), new IllegalStateException());
            }
        }
    }

    private void writeNewContentsIfDifferentFromExistingContents() throws URISyntaxException, IOException {
        if (this.isOverwriteUnchangedFiles() || !this.newContents.equals(this.existingContents)) {
            this.write();
            this.addMessage(String.valueOf(this.positiveMessage) + this.targetName);
        } else {
            this.addMessage("Content unchanged for " + this.targetName);
        }
    }

    private boolean isOverwriteUnchangedFiles() {
        return this.getIncrementalitySettings().isOverwriteUnchangedFiles();
    }

    private void write() throws IOException, URISyntaxException {
        new Writer(this.target, this.newContents).write();
        this.currentOutputFile = this.template.addOutputFile(this.targetName, UriUtil.fileToUri(this.target));
        if (this.outputMode == OutputMode.MERGE) {
            for (ProtectedRegion pr : this.module.getContext().getPartitioner().partition(this.newContents).getProtectedRegions()) {
                this.currentOutputFile.addProtectedRegion(pr.getId(), pr.isEnabled(), pr.getOffset());
            }
        }
    }

    @Override
    protected void addProtectedRegionWarning(ProtectedRegionWarning warning) {
        super.addProtectedRegionWarning(new ProtectedRegionWarning(warning.getId(), this.target.getAbsolutePath()));
    }

    private static enum OutputMode {
        WRITE,
        MERGE,
        APPEND;

    }
}

