/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.engine.traceability.fine.trace;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.ModelLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TextLocation;

public class TraceLink {
    public final ModelLocation source;
    public final TextLocation destination;

    public TraceLink(ModelLocation source, TextLocation destination) {
        this.source = source;
        this.destination = destination;
    }

    public ModelLocation getSource() {
        return this.source;
    }

    public TextLocation getDestination() {
        return this.destination;
    }

    public Collection<? extends Object> getAllContents() {
        LinkedList<Object> allContents = new LinkedList<Object>();
        allContents.add(this);
        allContents.addAll(this.source.getAllContents());
        allContents.addAll(this.destination.getAllContents());
        return allContents;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TraceLink)) {
            return false;
        }
        TraceLink other = (TraceLink)object;
        return this.source.equals(other.source) && this.destination.equals(other.destination);
    }

    public int hashCode() {
        return this.source.hashCode() + this.destination.hashCode();
    }

    public String toString() {
        return "<TraceLink source:" + this.source + ", destination:" + this.destination + ">";
    }
}

