/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.formatter.linebyline;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.formatter.linebyline.Line;
import org.eclipse.epsilon.egl.formatter.linebyline.LineFactory;
import org.eclipse.epsilon.egl.util.FileUtil;

public class LineByLineNavigator<T extends Line> {
    private final List<T> lines = new LinkedList<T>();
    private int lineIndex = 0;

    public LineByLineNavigator(String text, LineFactory<T> lineFactory) {
        for (String unformattedRawLine : Arrays.asList(text.split(FileUtil.NEWLINE))) {
            this.lines.add(lineFactory.createLine(unformattedRawLine));
        }
    }

    public boolean hasPreviousLine() {
        return this.lineIndex != 0;
    }

    public T getPreviousLine() {
        return (T)(this.hasPreviousLine() ? (Line)this.lines.get(this.lineIndex - 1) : null);
    }

    public T getCurrentLine() {
        return (T)((Line)this.lines.get(this.lineIndex));
    }

    public boolean hasMoreLines() {
        return this.lineIndex < this.lines.size();
    }

    public void insertBeforeCurrentLine(T formattedLine) {
        this.lines.add(this.lineIndex, formattedLine);
        ++this.lineIndex;
    }

    public void joinCurrentToPrevious() {
        this.joinCurrentToPrevious("");
    }

    public void joinCurrentToPrevious(String glue) {
        ((Line)this.getPreviousLine()).addSuffix(glue).join((Line)this.getCurrentLine());
        this.lines.remove(this.lineIndex);
    }

    public void moveToNextLine() {
        ++this.lineIndex;
    }

    public String getText() {
        StringBuilder formattedText = new StringBuilder();
        for (Line line : this.lines) {
            formattedText.append(line.getText());
            formattedText.append(FileUtil.NEWLINE);
        }
        return formattedText.toString().trim();
    }
}

