/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.output;

import org.eclipse.epsilon.egl.merge.output.Region;

public abstract class ProtectedRegion
extends Region {
    private final String id;
    private final int offset;
    private final String defaultValue;
    private boolean enabled;

    protected ProtectedRegion(String id, int offset) {
        this(id, offset, true);
    }

    protected ProtectedRegion(String id, int offset, boolean enabled) {
        this(id, offset, enabled, "");
    }

    protected ProtectedRegion(String id, int offset, boolean enabled, String contents) {
        super(contents);
        if (id == null) {
            throw new NullPointerException("id must not be null");
        }
        this.id = id;
        this.offset = offset;
        this.enabled = enabled;
        this.defaultValue = contents;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public abstract String toString();

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProtectedRegion)) {
            return false;
        }
        ProtectedRegion that = (ProtectedRegion)o;
        return this.id.equals(that.id) && this.offset == that.offset && this.enabled == that.enabled;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 37 * result + this.id.hashCode();
        result += 37 * result + this.offset;
        result += 37 * result + (this.enabled ? 1 : 0);
        return result;
    }
}

