/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.partition;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epsilon.egl.merge.output.Output;
import org.eclipse.epsilon.egl.merge.output.ProtectedRegion;
import org.eclipse.epsilon.egl.merge.output.Region;
import org.eclipse.epsilon.egl.merge.partition.Partitioner;
import org.eclipse.epsilon.egl.util.FileUtil;

public class CommentBlockPartitioner
implements Partitioner {
    private final String startComment;
    private final String endComment;
    private String firstLine;
    private String contents = "(.*^[\\s]*)";
    private String lastLine;

    private static String escape(String text) {
        String escaped = text.replaceAll("\\*", "\\\\*");
        return escaped;
    }

    public CommentBlockPartitioner(String startComment, String endComment) {
        this.startComment = startComment == null ? "" : startComment;
        this.endComment = endComment == null ? "" : endComment;
        this.init();
    }

    private void init() {
        this.initFirstLine();
        this.initLastLine();
    }

    private void initFirstLine() {
        StringBuilder regex = new StringBuilder();
        if (this.startComment.length() > 0) {
            regex.append(CommentBlockPartitioner.escape(this.startComment));
            regex.append("[\\s]*");
        }
        regex.append("protected region ");
        regex.append("(.*?) ");
        regex.append("(on|off) begin");
        if (this.endComment.length() > 0) {
            regex.append("[\\s]*");
            regex.append(CommentBlockPartitioner.escape(this.endComment));
        }
        regex.append("[\\s]*^");
        this.firstLine = regex.toString();
    }

    private void initLastLine() {
        StringBuilder regex = new StringBuilder();
        if (this.startComment.length() > 0) {
            regex.append(CommentBlockPartitioner.escape(this.startComment));
            regex.append("[\\s]*");
        }
        regex.append("protected region ");
        regex.append("\\1 ");
        regex.append("end");
        if (this.endComment.length() > 0) {
            regex.append("[\\s]*");
            regex.append(CommentBlockPartitioner.escape(this.endComment));
        }
        this.lastLine = regex.toString();
    }

    public String getStartComment() {
        return this.startComment;
    }

    public String getEndComment() {
        return this.endComment;
    }

    public String getFirstLine(String id, boolean enabled) {
        StringBuilder builder = new StringBuilder();
        if (this.startComment.length() > 0) {
            builder.append(this.startComment);
            builder.append(' ');
        }
        builder.append("protected region ");
        builder.append(id);
        builder.append(" ");
        builder.append(enabled ? "on" : "off");
        builder.append(" begin");
        if (this.endComment.length() > 0) {
            builder.append(' ');
            builder.append(this.endComment);
        }
        return builder.toString();
    }

    public String getLastLine(String id) {
        StringBuilder builder = new StringBuilder();
        if (this.startComment.length() > 0) {
            builder.append(this.startComment);
            builder.append(' ');
        }
        builder.append("protected region ");
        builder.append(id);
        builder.append(" end");
        if (this.endComment.length() > 0) {
            builder.append(' ');
            builder.append(this.endComment);
        }
        return builder.toString();
    }

    @Override
    public Output partition(String text) {
        return this.partition(text, 0);
    }

    @Override
    public Output partition(String text, int offset) {
        LinkedList<Region> regions = new LinkedList<Region>();
        Pattern pattern = Pattern.compile(String.valueOf(this.firstLine) + this.contents + this.lastLine, 40);
        Matcher matcher = pattern.matcher(text);
        int previousEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > previousEnd) {
                regions.add(new Region(text.substring(previousEnd, matcher.start())));
            }
            previousEnd = matcher.end();
            boolean enabled = matcher.group(2) != null && matcher.group(2).equals("on");
            CommentedProtectedRegion region = new CommentedProtectedRegion(matcher.group(1), matcher.start() + offset, enabled, matcher.group(3));
            regions.add(region);
        }
        if (previousEnd < text.length()) {
            regions.add(new Region(text.substring(previousEnd)));
        }
        return new Output(regions);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{start=\"" + this.startComment + "\", " + "end=\"" + this.endComment + "\"}";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CommentBlockPartitioner)) {
            return false;
        }
        CommentBlockPartitioner that = (CommentBlockPartitioner)o;
        return this.startComment.equals(that.startComment) && this.endComment.equals(that.endComment);
    }

    public int hashCode() {
        int result = 17;
        result += 37 * this.startComment.hashCode();
        return result += 37 * this.endComment.hashCode();
    }

    class CommentedProtectedRegion
    extends ProtectedRegion {
        CommentedProtectedRegion(String id, int offset, boolean enabled, String contents) {
            super(id, offset, enabled, contents);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(CommentBlockPartitioner.this.getFirstLine(this.getId(), this.isEnabled()));
            builder.append(FileUtil.NEWLINE);
            if (this.isEnabled()) {
                builder.append(this.getContents());
            } else {
                builder.append(this.getDefaultValue());
            }
            builder.append(CommentBlockPartitioner.this.getLastLine(this.getId()));
            return builder.toString();
        }
    }
}

