/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.egl.model.EglMarkerSection;
import org.eclipse.epsilon.egl.parse.EglToken;

public abstract class EglSection
implements ModuleElement {
    private final AST ast;

    public static EglSection createFrom(AST ast) {
        if (EglSection.isMarker(ast)) {
            return new EglMarkerSection(ast);
        }
        return null;
    }

    private static boolean isMarker(AST ast) {
        return EglToken.TokenType.typeOf(ast.getType()) == EglToken.TokenType.START_MARKER_TAG;
    }

    protected EglSection(AST ast) {
        this.ast = ast;
    }

    @Override
    public AST getAst() {
        return this.ast;
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public abstract String getText();

    public String toString() {
        String text = this.getText();
        if (text.length() > 30) {
            return String.valueOf(text.substring(0, 30)) + "...";
        }
        return text;
    }
}

