/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class CachedResourceSet
extends ResourceSetImpl {
    protected static final Cache cache = new Cache();

    public static Cache getCache() {
        return cache;
    }

    @Override
    public Resource createResource(URI uri) {
        Resource cachedResource = CachedResourceSet.getCache().checkoutResource(uri);
        if (cachedResource == null) {
            cachedResource = super.createResource(uri);
            if (cachedResource == null) {
                cachedResource = new XMIResourceFactoryImpl().createResource(uri);
                this.getResources().add(cachedResource);
            }
            cachedResource.setTrackingModification(false);
            if (cachedResource instanceof XMLResource) {
                this.configure((XMLResource)cachedResource);
            }
            CachedResourceSet.getCache().cacheResource(uri, cachedResource);
        }
        return cachedResource;
    }

    public void configure(XMLResource resource) {
        Map<Object, Object> loadOptions = resource.getDefaultLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        loadOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
    }

    public static class Cache {
        protected ArrayList<CacheItem> items = new ArrayList();

        public void cacheResource(URI uri, Resource resource) {
            CacheItem item = new CacheItem();
            item.setUri(uri);
            item.setResource(resource);
            item.incrementCheckedOut();
            this.items.add(item);
        }

        public boolean isCached(URI uri) {
            for (CacheItem item : this.items) {
                if (!item.getUri().equals(uri)) continue;
                return item.getResource() != null;
            }
            return false;
        }

        public Resource checkoutResource(URI uri) {
            CacheItem toCheckout = null;
            for (CacheItem item : this.items) {
                if (!item.getUri().equals(uri)) continue;
                toCheckout = item;
                break;
            }
            if (toCheckout == null) {
                return null;
            }
            if (toCheckout.getResource() != null) {
                toCheckout.incrementCheckedOut();
                return toCheckout.getResource();
            }
            this.items.remove(toCheckout);
            return null;
        }

        public void returnResource(Resource resource) {
            CacheItem toReturn = null;
            for (CacheItem item : this.items) {
                if (!resource.equals(item.getResource())) continue;
                toReturn = item;
                break;
            }
            if (toReturn != null) {
                toReturn.decrementCheckedOut();
                if (toReturn.getCheckedOut() == 0) {
                    this.items.remove(toReturn);
                }
            }
        }

        public void clear() {
            this.items.clear();
        }

        public int size() {
            return this.items.size();
        }

        public ArrayList<CacheItem> getItems() {
            return this.items;
        }

        public class CacheItem {
            protected WeakReference<Resource> resourceReference;
            public URI uri;
            public int checkedOut = 0;

            public Resource getResource() {
                return (Resource)this.resourceReference.get();
            }

            public void setResource(Resource resource) {
                this.resourceReference = new WeakReference<Resource>(resource);
            }

            public void setUri(URI uri) {
                this.uri = uri;
            }

            public URI getUri() {
                return this.uri;
            }

            public void incrementCheckedOut() {
                ++this.checkedOut;
            }

            public void decrementCheckedOut() {
                --this.checkedOut;
            }

            public int getCheckedOut() {
                return this.checkedOut;
            }
        }
    }
}

