/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyAssignmentException;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;

public class EmfPropertySetter
extends AbstractPropertySetter
implements IReflectivePropertySetter {
    @Override
    public Object coerce(Object value) throws EolIllegalPropertyException {
        if (this.getEStructuralFeature().isMany() && !(value instanceof Collection)) {
            return CollectionUtil.asList(value);
        }
        return value;
    }

    @Override
    public boolean conforms(Object value) throws EolIllegalPropertyException {
        if (this.propertyIsFixed()) {
            return false;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return this.propertyCanHoldCollections() && this.isConformantSizeForProperty(collection) && this.allAreConformantTypeForProperty(collection);
        }
        return this.isConformantTypeForProperty(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void invoke(Object value) throws EolRuntimeException {
        EStructuralFeature sf = this.getEStructuralFeature();
        if (sf.isMany()) {
            if (value == null) return;
            Collection sourceValues = (Collection)this.getEObject().eGet(sf);
            if (!(value instanceof Collection)) throw new EolIllegalPropertyAssignmentException(this.getProperty(), this.getAst());
            this.copyCollectionValues((Collection)value, sourceValues);
            return;
        } else {
            this.getEObject().eSet(sf, value);
        }
    }

    protected void copyCollectionValues(Collection<?> source, Collection<Object> target) {
        target.clear();
        for (Object element : source) {
            target.add(element);
        }
    }

    protected EObject getEObject() throws EolIllegalPropertyException {
        if (this.object instanceof EObject) {
            return (EObject)this.object;
        }
        throw new EolIllegalPropertyException(this.object, this.property, this.ast, this.context);
    }

    private EStructuralFeature getEStructuralFeature() throws EolIllegalPropertyException {
        EStructuralFeature sf = EmfUtil.getEStructuralFeature(this.getEObject().eClass(), this.property);
        if (sf == null) {
            throw new EolIllegalPropertyException(this.object, this.property, this.ast, this.context);
        }
        return sf;
    }

    private boolean propertyIsFixed() throws EolIllegalPropertyException {
        return !this.getEStructuralFeature().isChangeable();
    }

    private boolean propertyCanHoldCollections() throws EolIllegalPropertyException {
        return this.getEStructuralFeature().isMany();
    }

    private boolean isConformantSizeForProperty(Collection<?> values) throws EolIllegalPropertyException {
        return this.lowerbound() <= values.size() && values.size() <= this.upperbound();
    }

    private int upperbound() throws EolIllegalPropertyException {
        int upperbound = this.getEStructuralFeature().getUpperBound();
        return upperbound == -1 ? Integer.MAX_VALUE : upperbound;
    }

    private int lowerbound() throws EolIllegalPropertyException {
        return this.getEStructuralFeature().getLowerBound();
    }

    private boolean allAreConformantTypeForProperty(Collection<?> values) throws EolIllegalPropertyException {
        for (Object value : values) {
            if (this.isConformantTypeForProperty(value)) continue;
            return false;
        }
        return true;
    }

    private boolean isConformantTypeForProperty(Object value) throws EolIllegalPropertyException {
        return this.getEStructuralFeature().getEType().isInstance(value);
    }
}

