/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.xml.MixedElementOperationContributor;
import org.eclipse.epsilon.emc.emf.xml.XmlPropertySetter;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class XmlModel
extends AbstractEmfModel
implements IOperationContributorProvider {
    public static String PROPERTY_MODEL_FILE = "modelFile";
    public static String PROPERTY_XSD_FILE = "xsdFile";
    protected MixedElementOperationContributor mixedElementOperationContributor = new MixedElementOperationContributor();
    protected String modelFile = "";
    protected String xsdFile = "";
    static String basePath = "E://Projects//Eclipse//3.3//workspace//org.eclipse.epsilon.eol.models.emf//src//org//epsilon//eol//models//emf//xml//";

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        this.modelFile = String.valueOf(StringUtil.toString(basePath)) + properties.getProperty(PROPERTY_MODEL_FILE);
        this.xsdFile = String.valueOf(StringUtil.toString(basePath)) + properties.getProperty(PROPERTY_XSD_FILE);
        this.load();
    }

    public static void main(String[] args) throws Exception {
        XmlModel model = new XmlModel();
        model.modelFile = String.valueOf(basePath) + "Test.xml";
        model.xsdFile = String.valueOf(basePath) + "TestCases.xsd";
        model.load();
        model.store(String.valueOf(model.modelFile) + "copy.xml");
    }

    @Override
    protected void loadModel() throws EolModelLoadingException {
        Map<String, Object> etfm;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.xsdFile != null && this.xsdFile.endsWith("xsd")) {
            XSDEcoreBuilder xsdEcoreBuilder = new XSDEcoreBuilder();
            Collection<EObject> eCorePackages = xsdEcoreBuilder.generate(URI.createFileURI(this.xsdFile));
            for (EPackage ePackage : eCorePackages) {
                if (ePackage.getNsURI() == null || ePackage.getNsURI().length() == 0) {
                    ePackage.setNsURI(ePackage.getName());
                }
                resourceSet.getPackageRegistry().put(ePackage.getNsURI(), ePackage);
            }
        }
        if (!(etfm = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()).containsKey("*")) {
            etfm.put("*", new GenericXMLResourceFactoryImpl());
        }
        Resource resource = resourceSet.createResource(URI.createFileURI(this.modelFile));
        try {
            if (this.readOnLoad) {
                resource.load(null);
            }
        }
        catch (IOException e) {
            throw new EolModelLoadingException(e, this);
        }
        this.modelImpl = resource;
    }

    @Override
    public boolean store() {
        return this.store(this.modelFile);
    }

    @Override
    public boolean store(String fileName) {
        OutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                this.modelImpl.save(fos, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new XmlPropertySetter();
    }

    @Override
    public OperationContributor getOperationContributor() {
        return this.mixedElementOperationContributor;
    }
}

