/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.graphml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.emc.graphml.GraphmlConfiguration;
import org.eclipse.epsilon.emc.graphml.GraphmlModel;
import org.eclipse.epsilon.emc.graphml.LinkFeatureLabelParser;
import org.eclipse.epsilon.emc.graphml.OrphanLink;
import org.eclipse.epsilon.emc.graphml.ValuedSlotFeatureLabelParser;
import org.eclipse.epsilon.emc.muddle.BooleanType;
import org.eclipse.epsilon.emc.muddle.Feature;
import org.eclipse.epsilon.emc.muddle.IntegerType;
import org.eclipse.epsilon.emc.muddle.LinkElementType;
import org.eclipse.epsilon.emc.muddle.Muddle;
import org.eclipse.epsilon.emc.muddle.MuddleElement;
import org.eclipse.epsilon.emc.muddle.MuddleElementType;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.RealType;
import org.eclipse.epsilon.emc.muddle.Slot;
import org.eclipse.epsilon.emc.muddle.Type;
import org.eclipse.epsilon.eol.EolModule;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;

public class GraphmlImporter {
    protected Muddle graph = null;
    protected HashMap<String, MuddleElement> nodeMap;
    protected HashMap<MuddleElement, Element> nodeElementMap;
    protected Element graphElement = null;
    protected Namespace namespace;
    protected List<OrphanLink> orphanEdges;
    protected GraphmlConfiguration configuration;
    protected List<MuddleElement> referenceNodes;

    public static void main(String[] args) throws Exception {
        GraphmlModel model = new GraphmlModel();
        model.setFile(new File("/Users/dimitrioskolovos/Downloads/eclipse-epsilon-kepler/workspace/org.eclipse.epsilon.emc.graphml/samples/template.graphml"));
        model.setName("X");
        model.load();
        EolModule module = new EolModule();
        module.parse("Element.all.title.println();");
        module.getContext().getModelRepository().addModel(model);
        module.execute();
    }

    public Muddle importGraph(File file) throws Exception {
        this.graph = MuddleFactory.eINSTANCE.createMuddle();
        this.nodeMap = new HashMap();
        this.nodeElementMap = new HashMap();
        this.orphanEdges = new ArrayList<OrphanLink>();
        this.referenceNodes = new ArrayList<MuddleElement>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        Element root = doc.getDocument().getRootElement();
        this.namespace = root.getNamespace();
        this.graphElement = root.getChild("graph", this.namespace);
        this.configuration = new GraphmlConfiguration(root);
        this.populateGraph();
        this.adjustSlotPrototypeMultiplicitiesAndSlotValueTypes();
        return this.graph;
    }

    protected void populateGraph() {
        MuddleElement node;
        for (Element nodeElement : this.getNodeElements()) {
            String nodeTypeName = this.getElementData(nodeElement, this.configuration.getNodeTypeKey());
            if (nodeTypeName == null) continue;
            boolean isReference = false;
            if (nodeTypeName.startsWith("@")) {
                nodeTypeName = nodeTypeName.substring(1);
                isReference = true;
            }
            node = MuddleFactory.eINSTANCE.createMuddleElement();
            node.setId(nodeElement.getAttributeValue("id"));
            this.nodeMap.put(node.getId(), node);
            this.nodeElementMap.put(node, nodeElement);
            if (isReference) {
                this.referenceNodes.add(node);
            }
            this.graph.getElements().add(node);
            node.setType(this.nodeTypeForName(nodeTypeName));
            if (isReference) continue;
            this.createPrimaryPrototypeSlot(node, nodeElement, this.configuration.getNodePrimarySlotPrototypeNameKey());
        }
        for (MuddleElement node2 : this.graph.getElements()) {
            Element nodeElement = this.nodeElementMap.get(node2);
            this.populateSlots(node2, nodeElement);
        }
        for (MuddleElement referenceNode : this.referenceNodes) {
            MuddleElement target = this.findReferenceTarget(referenceNode);
            if (target == null) continue;
            this.nodeMap.put(referenceNode.getId(), target);
        }
        this.graph.getElements().removeAll(this.referenceNodes);
        for (MuddleElement referenceNode : this.referenceNodes) {
            this.annihilate(referenceNode);
        }
        for (Element edgeElement : this.getEdgeElements()) {
            String edgeTypeName = this.getElementData(edgeElement, this.configuration.getEdgeTypeKey());
            if (edgeTypeName != null) continue;
            MuddleElement source = this.nodeMap.get(edgeElement.getAttributeValue("source"));
            MuddleElement target = this.nodeMap.get(edgeElement.getAttributeValue("target"));
            String label = this.getFirstLabel(edgeElement);
            if (label == null) {
                this.orphanEdges.add(new OrphanLink(source, target));
                continue;
            }
            Feature prototype = new LinkFeatureLabelParser(label).getFeature();
            Slot slot = this.addSlot(source, prototype);
            slot.setFeature(this.addSlotPrototype(source.getType(), prototype));
            slot.getValues().add(target);
        }
        for (OrphanLink orphanEdge : this.orphanEdges) {
            Slot slot = this.findSuitableSlot(orphanEdge.getSource(), orphanEdge.getTarget());
            if (slot == null) continue;
            slot.getValues().add(orphanEdge.getTarget());
        }
        ArrayList<MuddleElement> typedEdgeNodes = new ArrayList<MuddleElement>();
        for (Element edgeElement : this.getEdgeElements()) {
            Feature roleInTargetPrototype;
            Feature roleInSourcePrototype;
            Feature targetPrototype;
            String edgeTypeName = this.getElementData(edgeElement, this.configuration.getEdgeTypeKey());
            if (edgeTypeName == null) continue;
            node = MuddleFactory.eINSTANCE.createMuddleElement();
            node.setId(edgeElement.getAttributeValue("id"));
            this.nodeElementMap.put(node, edgeElement);
            this.graph.getElements().add(node);
            typedEdgeNodes.add(node);
            LinkElementType edgeType = this.edgeTypeForName(edgeTypeName);
            node.setType(edgeType);
            this.createPrimaryPrototypeSlot(node, edgeElement, this.configuration.getEdgePrimarySlotPrototypeNameKey());
            Feature sourcePrototype = this.createEdgeTypeSlotPrototype(node, this.configuration.getEdgeSourceKey());
            if (sourcePrototype != null && edgeType.getSourceFeature() == null) {
                edgeType.setSourceFeature(sourcePrototype);
                edgeType.getFeatures().add(sourcePrototype);
            }
            if ((targetPrototype = this.createEdgeTypeSlotPrototype(node, this.configuration.getEdgeTargetKey())) != null && edgeType.getTargetFeature() == null) {
                edgeType.setTargetFeature(targetPrototype);
                edgeType.getFeatures().add(targetPrototype);
            }
            if ((roleInSourcePrototype = this.createEdgeTypeSlotPrototype(node, this.configuration.getEdgeRoleInSourceKey())) != null && edgeType.getRoleInSourceFeature() == null) {
                edgeType.setRoleInSourceFeature(roleInSourcePrototype);
            }
            if ((roleInTargetPrototype = this.createEdgeTypeSlotPrototype(node, this.configuration.getEdgeRoleInTargetKey())) == null || edgeType.getRoleInTargetFeature() != null) continue;
            edgeType.setRoleInTargetFeature(roleInTargetPrototype);
        }
        for (MuddleElement edgeNode : typedEdgeNodes) {
            Element edgeElement = this.nodeElementMap.get(edgeNode);
            this.populateSlots(edgeNode, edgeElement);
            MuddleElement source = this.nodeMap.get(edgeElement.getAttributeValue("source"));
            MuddleElement target = this.nodeMap.get(edgeElement.getAttributeValue("target"));
            if (source != null) {
                this.addEdgeNodeToNode(edgeNode, source, ((LinkElementType)edgeNode.getType()).getRoleInSourceFeature());
                this.addNodeToEdgeNode(edgeNode, source, ((LinkElementType)edgeNode.getType()).getSourceFeature());
            }
            if (target == null) continue;
            this.addEdgeNodeToNode(edgeNode, target, ((LinkElementType)edgeNode.getType()).getRoleInTargetFeature());
            this.addNodeToEdgeNode(edgeNode, target, ((LinkElementType)edgeNode.getType()).getTargetFeature());
        }
        for (MuddleElement muddleElement : this.graph.getElements()) {
            Element element;
            String contentsFeatureName;
            if (muddleElement.getType() == null || (contentsFeatureName = this.getElementData(element = this.nodeElementMap.get(muddleElement), this.configuration.getNodeContentsKey())) == null) continue;
            Feature contentsFeature = this.getOrCreateFeature(muddleElement.getType(), contentsFeatureName);
            contentsFeature.setMany(true);
            Slot contentsSlot = this.findSlot(muddleElement, contentsFeature);
            if (contentsSlot == null) {
                contentsSlot = MuddleFactory.eINSTANCE.createSlot();
                contentsSlot.setFeature(contentsFeature);
                contentsSlot.setOwningElement(muddleElement);
            }
            for (Object child : element.getChildren()) {
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                for (Object grandChild : childElement.getChildren()) {
                    Element grandChildElement;
                    MuddleElement contentsElement;
                    if (!(grandChild instanceof Element) || (contentsElement = this.nodeMap.get((grandChildElement = (Element)grandChild).getAttributeValue("id"))) == null) continue;
                    contentsSlot.getValues().add(contentsElement);
                }
            }
        }
    }

    protected Feature getOrCreateFeature(MuddleElementType type, String featureName) {
        Feature feature = null;
        for (Feature candidateFeature : type.getFeatures()) {
            if (!candidateFeature.getName().equals(featureName)) continue;
            feature = candidateFeature;
        }
        if (feature == null) {
            feature = MuddleFactory.eINSTANCE.createFeature();
            feature.setName(featureName);
            feature.setOwningType(type);
        }
        return feature;
    }

    protected Feature createEdgeTypeSlotPrototype(MuddleElement edgeNode, String key) {
        String slotPrototypeLabel = this.getNodeData(edgeNode, key);
        if (slotPrototypeLabel == null) {
            return null;
        }
        Feature prototype = new LinkFeatureLabelParser(slotPrototypeLabel).getFeature();
        return prototype;
    }

    protected void addNodeToEdgeNode(MuddleElement edgeNode, MuddleElement node, Feature prototype) {
        if (prototype == null) {
            return;
        }
        Slot slot = this.addSlot(edgeNode, prototype);
        slot.getValues().add(node);
    }

    protected void addEdgeNodeToNode(MuddleElement edgeNode, MuddleElement node, Feature prototype) {
        if (prototype == null) {
            return;
        }
        Slot slot = this.addSlot(node, this.addSlotPrototype(node.getType(), this.clone(prototype)));
        slot.getValues().add(edgeNode);
    }

    protected String getNodeData(MuddleElement node, String key) {
        return this.getElementData(this.nodeElementMap.get(node), key);
    }

    protected void populateSlots(MuddleElement node, Element element) {
        for (String label : this.getLabels(element)) {
            if (this.isSlotValueLabel(label)) {
                ValuedSlotFeatureLabelParser parser = new ValuedSlotFeatureLabelParser(label);
                Slot slot = this.addSlot(node, parser.getFeature());
                slot.setFeature(this.addSlotPrototype(node.getType(), parser.getFeature()));
                slot.getValues().add(parser.getValue());
                continue;
            }
            Slot primarySlot = this.getPrimarySlot(node);
            if (primarySlot == null) continue;
            primarySlot.getValues().add(label);
        }
    }

    protected void createPrimaryPrototypeSlot(MuddleElement node, Element element, String defaultSlotPrototypeNameKey) {
        String defaultSlotPrototypeName = defaultSlotPrototypeNameKey;
        if (defaultSlotPrototypeName == null) {
            return;
        }
        String defaultSlotPrototypeLabel = this.getElementData(element, defaultSlotPrototypeName);
        if (defaultSlotPrototypeLabel == null) {
            return;
        }
        Feature prototype = new ValuedSlotFeatureLabelParser(String.valueOf(defaultSlotPrototypeLabel) + " = 0").getFeature();
        prototype.setPrimary(true);
        this.addSlotPrototype(node.getType(), prototype);
    }

    protected String getElementData(Element e, String key) {
        for (Element descriptionElement : this.getDescendants(e, "data")) {
            if (!descriptionElement.getAttributeValue("key", "").equals(key)) continue;
            String data = descriptionElement.getText().trim();
            if (data.length() == 0) {
                return null;
            }
            return data;
        }
        return null;
    }

    protected void annihilate(MuddleElement node) {
        node.setType(null);
        for (Slot slot : node.getSlots()) {
            slot.setFeature(null);
            slot.getValues().clear();
        }
    }

    protected MuddleElement findReferenceTarget(MuddleElement referenceNode) {
        for (MuddleElement node : referenceNode.getType().getInstances()) {
            if (this.referenceNodes.contains(node) || !this.matches(node, referenceNode)) continue;
            return node;
        }
        return null;
    }

    protected boolean matches(MuddleElement node, MuddleElement referenceNode) {
        for (Slot referenceSlot : referenceNode.getSlots()) {
            Slot slot = this.findSlot(node, referenceSlot.getFeature());
            if (slot == null) {
                return false;
            }
            for (Object e : referenceSlot.getValues()) {
                if (slot.getValues().contains(e)) continue;
                return false;
            }
        }
        return true;
    }

    protected Slot findSlot(MuddleElement node, Feature slotPrototype) {
        for (Slot slot : node.getSlots()) {
            if (!slot.getFeature().equals(slotPrototype)) continue;
            return slot;
        }
        return null;
    }

    protected void adjustSlotPrototypeMultiplicitiesAndSlotValueTypes() {
        for (MuddleElement node : this.graph.getElements()) {
            for (Slot slot : node.getSlots()) {
                Type slotType;
                if (!slot.getFeature().isMany() && slot.getValues().size() > 1) {
                    slot.getFeature().setMany(true);
                }
                if (slot.getValues().size() <= 0 || !((slotType = slot.getFeature().getType()) instanceof IntegerType) && !(slotType instanceof BooleanType) && !(slotType instanceof RealType)) continue;
                ArrayList<Object> castedValues = new ArrayList<Object>();
                for (Object e : slot.getValues()) {
                    castedValues.add(this.cast(e, slotType));
                }
                slot.getValues().clear();
                slot.getValues().addAll(castedValues);
            }
        }
    }

    protected Object cast(Object object, Type type) {
        if (type instanceof IntegerType) {
            try {
                return Integer.parseInt("" + object);
            }
            catch (Exception ex) {
                return 0;
            }
        }
        if (type instanceof BooleanType) {
            try {
                return Boolean.parseBoolean("" + object);
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (type instanceof RealType) {
            try {
                return Float.valueOf(Float.parseFloat("" + object));
            }
            catch (Exception ex) {
                return Float.valueOf(0.0f);
            }
        }
        return object;
    }

    protected Slot findSuitableSlot(MuddleElement source, MuddleElement target) {
        Slot slot2;
        if (source == null || source.getType() == null) {
            return null;
        }
        Feature slotPrototype = this.findSuitableSlotPrototype(source.getType(), target);
        if (slotPrototype == null) {
            return null;
        }
        for (Slot slot2 : source.getSlots()) {
            if (slot2.getFeature() != slotPrototype) continue;
            return slot2;
        }
        slot2 = MuddleFactory.eINSTANCE.createSlot();
        slot2.setFeature(slotPrototype);
        source.getSlots().add(slot2);
        return slot2;
    }

    protected Feature findSuitableSlotPrototype(MuddleElementType type, MuddleElement value) {
        for (Feature slotPrototype : type.getFeatures()) {
            for (Slot slot : slotPrototype.getSlots()) {
                for (Object e : slot.getValues()) {
                    if (!(e instanceof MuddleElement) || !((MuddleElement)e).getType().equals(value.getType())) continue;
                    return slotPrototype;
                }
            }
        }
        return null;
    }

    protected boolean isReferenceLabel(String label) {
        return label.startsWith("@");
    }

    protected boolean isSlotValueLabel(String label) {
        return label.indexOf(61) > -1;
    }

    protected Slot addSlot(MuddleElement node, Feature prototype) {
        for (Slot existingSlot : node.getSlots()) {
            if (!existingSlot.getFeature().getName().equals(prototype.getName())) continue;
            return existingSlot;
        }
        Slot slot = MuddleFactory.eINSTANCE.createSlot();
        slot.setFeature(prototype);
        node.getSlots().add(slot);
        return slot;
    }

    protected Feature addSlotPrototype(MuddleElementType nodeType, Feature prototype) {
        for (Feature existingPrototype : nodeType.getFeatures()) {
            if (!existingPrototype.getName().equals(prototype.getName())) continue;
            if (existingPrototype.getType() == null) {
                existingPrototype.setType(prototype.getType());
            }
            if (!existingPrototype.isMany()) {
                existingPrototype.setMany(prototype.isMany());
            }
            if (!existingPrototype.isPrimary()) {
                existingPrototype.setPrimary(prototype.isPrimary());
            }
            return existingPrototype;
        }
        nodeType.getFeatures().add(prototype);
        return prototype;
    }

    protected Feature clone(Feature prototype) {
        Feature clone = MuddleFactory.eINSTANCE.createFeature();
        clone.setName(prototype.getName());
        clone.setPrimary(prototype.isPrimary());
        clone.setMany(prototype.isMany());
        return clone;
    }

    protected Slot getPrimarySlot(MuddleElement node) {
        Feature prototype;
        Feature primaryFeature = null;
        Iterator iterator = node.getType().getFeatures().iterator();
        if (iterator.hasNext() && (prototype = (Feature)iterator.next()).isPrimary()) {
            primaryFeature = prototype;
        }
        if (primaryFeature == null) {
            return null;
        }
        Slot primarySlot = null;
        for (Slot slot : node.getSlots()) {
            if (!slot.getFeature().equals(primaryFeature)) continue;
            primarySlot = slot;
            break;
        }
        if (primarySlot == null) {
            Slot slot;
            slot = MuddleFactory.eINSTANCE.createSlot();
            slot.setFeature(primaryFeature);
            slot.setOwningElement(node);
            return slot;
        }
        return primarySlot;
    }

    protected String getFirstLabel(Element e) {
        List<String> labels = this.getLabels(e);
        if (labels.size() > 0) {
            return labels.get(0);
        }
        return null;
    }

    protected List<String> getLabels(Element e) {
        String labelTag = "NodeLabel";
        String propertiesKey = this.configuration.getNodePropertiesKey();
        if (e.getName().equals("edge")) {
            labelTag = "EdgeLabel";
            propertiesKey = this.configuration.getEdgePropertiesKey();
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Element labelElement : this.getDescendants(e, labelTag)) {
            if (this.getFirstAncestor(labelElement, e.getName()) != e) continue;
            labels.addAll(this.getLabels(labelElement.getText()));
        }
        for (Element descriptionElement : this.getDescendants(e, "data")) {
            if (descriptionElement.getParentElement() != e || !descriptionElement.getAttributeValue("key", "").equals(propertiesKey)) continue;
            labels.addAll(this.getLabels(descriptionElement.getText()));
        }
        return labels;
    }

    protected Element getFirstAncestor(Element element, String name) {
        Element parentElement = element.getParentElement();
        while (parentElement != null) {
            if (parentElement.getName().equals(name)) {
                return parentElement;
            }
            parentElement = parentElement.getParentElement();
        }
        return null;
    }

    protected List<String> getLabels(String s) {
        ArrayList<String> labels = new ArrayList<String>();
        s = s.trim();
        String[] stringArray = s.split("\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label.trim().length() > 0) {
                labels.add(label.trim());
            }
            ++n2;
        }
        return labels;
    }

    protected List<Element> getDescendants(Element node, final String name) {
        ArrayList<Element> descendants = new ArrayList<Element>();
        Iterator iterator = node.getDescendants(new Filter(){

            public boolean matches(Object o) {
                return o instanceof Element && ((Element)o).getName().equals(name);
            }
        });
        while (iterator.hasNext()) {
            descendants.add((Element)iterator.next());
        }
        return descendants;
    }

    protected List<Element> getNodeElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element o : this.getDescendants(this.graphElement, "node")) {
            elements.add(o);
        }
        return elements;
    }

    protected List<Element> getEdgeElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element o : this.getDescendants(this.graphElement, "edge")) {
            elements.add(o);
        }
        return elements;
    }

    protected LinkElementType edgeTypeForName(String name) {
        return (LinkElementType)this.typeForName(name, true);
    }

    protected MuddleElementType nodeTypeForName(String name) {
        return this.typeForName(name, false);
    }

    protected MuddleElementType typeForName(String name, boolean edgeType) {
        int gt = name.indexOf(">");
        if (gt > -1) {
            String typeName = name.substring(0, gt).trim();
            String superTypeName = name.substring(gt + 1, name.length()).trim();
            MuddleElementType type = this.typeForName(typeName, edgeType);
            MuddleElementType superType = this.typeForName(superTypeName, edgeType);
            if (!type.getSuperTypes().contains(superType)) {
                type.getSuperTypes().add(superType);
            }
            return type;
        }
        for (Type type : this.graph.getTypes()) {
            if (!(type instanceof MuddleElementType) || !type.getName().equals(name)) continue;
            return (MuddleElementType)type;
        }
        MuddleElementType nodeType = null;
        nodeType = edgeType ? MuddleFactory.eINSTANCE.createLinkElementType() : MuddleFactory.eINSTANCE.createMuddleElementType();
        nodeType.setName(name);
        this.graph.getTypes().add(nodeType);
        return nodeType;
    }

    public GraphmlConfiguration getConfiguration() {
        return this.configuration;
    }
}

