/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.muddle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.epsilon.emc.muddle.Feature;
import org.eclipse.epsilon.emc.muddle.Muddle;
import org.eclipse.epsilon.emc.muddle.MuddleElement;
import org.eclipse.epsilon.emc.muddle.MuddleElementType;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.MuddleModelPropertyGetter;
import org.eclipse.epsilon.emc.muddle.MuddleModelPropertySetter;
import org.eclipse.epsilon.emc.muddle.Type;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.Model;

public class MuddleModel
extends Model {
    protected Muddle muddle;
    protected Set<Feature> unusedFeatures;
    protected MuddleModelPropertyGetter propertyGetter = new MuddleModelPropertyGetter(this);
    protected MuddleModelPropertySetter propertySetter = new MuddleModelPropertySetter(this);

    public static void main(String[] args) throws Exception {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName("m2");
        ePackage.setNsURI(ePackage.getName());
        ePackage.setNsPrefix(ePackage.getName());
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName("C1");
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName("a1");
        eAttribute.setEType(EcorePackage.eINSTANCE.getEClassifier("EString"));
        eClass.getEStructuralFeatures().add(eAttribute);
        ePackage.getEClassifiers().add(eClass);
        EObject object = ePackage.getEFactoryInstance().create(eClass);
        System.out.println(object.eGet(eClass.getEStructuralFeature("a1")));
        EAttribute eAttribute2 = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute2.setName("a2");
        eAttribute2.setEType(EcorePackage.eINSTANCE.getEClassifier("EString"));
        eClass.getEStructuralFeatures().add(eAttribute2);
        object.eSet(eClass.getEStructuralFeature("a2"), "v2");
    }

    @Override
    public Collection<?> allContents() {
        return this.muddle.getElements();
    }

    public Set<Feature> getUnusedFeatures() {
        if (this.unusedFeatures == null && this.muddle != null) {
            this.unusedFeatures = new HashSet<Feature>();
            for (Type type : this.muddle.getTypes()) {
                if (!(type instanceof MuddleElementType)) continue;
                this.unusedFeatures.addAll(((MuddleElementType)type).getFeatures());
            }
        }
        return this.unusedFeatures;
    }

    @Override
    public Object createInstance(String t) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        MuddleElementType type = this.muddleElementTypeForName(t);
        if (type == null) {
            type = MuddleFactory.eINSTANCE.createMuddleElementType();
            type.setName(t);
            this.muddle.getTypes().add(type);
        }
        MuddleElement element = MuddleFactory.eINSTANCE.createMuddleElement();
        element.setType(type);
        this.muddle.getElements().add(element);
        return element;
    }

    @Override
    public void deleteElement(Object o) throws EolRuntimeException {
        this.muddle.getElements().remove(o);
    }

    @Override
    public Collection<?> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        ArrayList<MuddleElement> elements = new ArrayList<MuddleElement>();
        for (MuddleElementType elementType : this.getAllSubTypes(this.muddleElementTypeForName(type))) {
            elements.addAll(elementType.getInstances());
        }
        return elements;
    }

    protected Set<MuddleElementType> getAllSubTypes(MuddleElementType elementType) {
        HashSet<MuddleElementType> allSubTypes = new HashSet<MuddleElementType>();
        this.collectAllSubTypes(elementType, allSubTypes);
        return allSubTypes;
    }

    protected void collectAllSubTypes(MuddleElementType elementType, Set<MuddleElementType> allSubTypes) {
        if (!allSubTypes.contains(elementType)) {
            allSubTypes.add(elementType);
            for (MuddleElementType subType : elementType.getSubTypes()) {
                this.collectAllSubTypes(subType, allSubTypes);
            }
        }
    }

    @Override
    public Collection<?> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        return this.muddleElementTypeForName(type).getInstances();
    }

    @Override
    public Object getElementById(String id) {
        for (MuddleElement element : this.muddle.getElements()) {
            if (!element.getId().equals(id)) continue;
            return element;
        }
        return null;
    }

    @Override
    public String getElementId(Object o) {
        return ((MuddleElement)o).getId();
    }

    @Override
    public Object getEnumerationValue(String arg0, String arg1) throws EolEnumerationValueNotFoundException {
        return null;
    }

    @Override
    public String getTypeNameOf(Object o) {
        return ((MuddleElement)o).getType().getName();
    }

    @Override
    public boolean hasType(String type) {
        return this.muddleElementTypeForName(type) != null;
    }

    @Override
    public boolean isInstantiable(String type) {
        return true;
    }

    @Override
    public boolean owns(Object o) {
        return this.muddle.getElements().contains(o);
    }

    @Override
    public void setElementId(Object o, String id) {
        ((MuddleElement)o).setId(id);
    }

    @Override
    public boolean store() {
        return false;
    }

    @Override
    public boolean store(String arg0) {
        return false;
    }

    protected MuddleElementType muddleElementTypeForName(String name) {
        for (Type type : this.muddle.getTypes()) {
            if (!(type instanceof MuddleElementType) || !type.getName().equals(name)) continue;
            return (MuddleElementType)type;
        }
        return null;
    }

    public void setMuddle(Muddle muddle) {
        this.muddle = muddle;
    }

    public Muddle getMuddle() {
        return this.muddle;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return this.propertyGetter;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return this.propertySetter;
    }

    @Override
    public void load() throws EolModelLoadingException {
    }
}

