/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.muddle;

import org.eclipse.epsilon.emc.muddle.BooleanType;
import org.eclipse.epsilon.emc.muddle.Feature;
import org.eclipse.epsilon.emc.muddle.IntegerType;
import org.eclipse.epsilon.emc.muddle.MuddleElement;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.MuddleModel;
import org.eclipse.epsilon.emc.muddle.RealType;
import org.eclipse.epsilon.emc.muddle.Slot;
import org.eclipse.epsilon.emc.muddle.StringType;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;

public class MuddleModelPropertyGetter
extends JavaPropertyGetter {
    protected MuddleModel model;

    public MuddleModelPropertyGetter(MuddleModel model) {
        this.model = model;
    }

    @Override
    public Object invoke(Object o, String property) throws EolRuntimeException {
        MuddleElement element = (MuddleElement)o;
        Feature feature = this.getFeature(element, property);
        if (feature == null) {
            return super.invoke(o, property);
        }
        this.model.getUnusedFeatures().remove(feature);
        Slot slot = this.getSlot(element, feature);
        if (slot == null) {
            slot = MuddleFactory.eINSTANCE.createSlot();
            slot.setFeature(feature);
            element.getSlots().add(slot);
        }
        if (feature.isMany()) {
            return slot.getValues();
        }
        if (slot.getValues().size() > 0) {
            return slot.getValues().get(0);
        }
        return this.getDefaultSlotValue(feature);
    }

    protected Object getDefaultSlotValue(Feature feature) {
        if (feature.getType() instanceof IntegerType) {
            return 0;
        }
        if (feature.getType() instanceof StringType) {
            return "";
        }
        if (feature.getType() instanceof RealType) {
            return 0.0;
        }
        if (feature.getType() instanceof BooleanType) {
            return false;
        }
        return null;
    }

    protected Slot getSlot(MuddleElement element, Feature feature) {
        for (Slot slot : element.getSlots()) {
            if (slot.getFeature() != feature) continue;
            return slot;
        }
        return null;
    }

    protected Feature getFeature(MuddleElement element, String property) {
        for (Feature feature : element.getType().getFeatures()) {
            if (!feature.getName().equals(property)) continue;
            return feature;
        }
        return null;
    }
}

