/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eml.execute.context.IEmlContext;
import org.eclipse.epsilon.eml.trace.MergeTrace;
import org.eclipse.epsilon.eml.trace.Merges;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolNoReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.erl.rules.ExtensibleNamedRule;

public class MergeRule
extends ExtensibleNamedRule
implements ModuleElement {
    protected AST guardAst = null;
    protected AST bodyAst = null;
    protected AST superRulesAst = null;
    protected EolFormalParameter leftParameter;
    protected EolFormalParameter rightParameter;
    protected List<EolFormalParameter> targetParameters = new ArrayList<EolFormalParameter>();
    protected Collection<?> allOfLeftType = null;
    protected Collection<?> allOfRightType = null;
    protected Collection<?> allOfLeftKind = null;
    protected Collection<?> allOfRightKind = null;
    protected boolean auto = false;
    HashSet<Match> mergedMatches = new HashSet();

    public MergeRule(AST ast) {
        this.parse(ast);
    }

    @Override
    public void parse(AST ast) {
        super.parse(ast);
        this.guardAst = AstUtil.getChild(ast, 79);
        this.bodyAst = AstUtil.getChild(ast, 61);
        AST leftParameterAst = ast.getFirstChild().getNextSibling();
        this.leftParameter = new EolFormalParameter(leftParameterAst);
        AST rightParameterAst = leftParameterAst.getNextSibling();
        this.rightParameter = new EolFormalParameter(rightParameterAst);
        AST mergedParametersAst = rightParameterAst.getNextSibling();
        AST mergedParameterAst = mergedParametersAst.getFirstChild();
        while (mergedParameterAst != null) {
            EolFormalParameter mergedParameter = new EolFormalParameter(mergedParameterAst);
            this.targetParameters.add(mergedParameter);
            mergedParameterAst = mergedParameterAst.getNextSibling();
        }
    }

    public boolean isLazy(IEmlContext context) throws EolRuntimeException {
        return EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "lazy", context);
    }

    public boolean isPrimary(IEmlContext context) throws EolRuntimeException {
        return EolAnnotationsUtil.getBooleanAnnotationValue(this.ast, "primary", context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean appliesTo(Match match, IEmlContext context) throws EolRuntimeException {
        boolean appliesToTypes;
        if (this.hasMerged(match)) {
            return true;
        }
        Object left = match.getLeft();
        Object right = match.getRight();
        if (!this.isGreedy()) {
            if (!this.getAllOfLeftType(context).contains(left)) return false;
            if (!this.getAllOfRightType(context).contains(right)) return false;
            boolean bl = true;
            appliesToTypes = bl;
        } else {
            if (!this.getAllOfLeftKind(context).contains(left)) return false;
            if (!this.getAllOfRightKind(context).contains(right)) return false;
            boolean bl = true;
            appliesToTypes = bl;
        }
        boolean guardSatisfied = true;
        if (appliesToTypes && this.guardAst != null) {
            context.getFrameStack().put(new Variable(this.leftParameter.getName(), left, this.leftParameter.getType(context), true));
            context.getFrameStack().put(new Variable(this.rightParameter.getName(), right, this.rightParameter.getType(context), true));
            context.getFrameStack().put(new Variable("self", this, EolAnyType.Instance, true));
            Object result = context.getExecutorFactory().executeBlockOrExpressionAst(this.guardAst.getFirstChild(), context);
            if (!(result instanceof Return)) throw new EolNoReturnException("Boolean", this.guardAst, context);
            Object value = Return.getValue(result);
            if (!(value instanceof Boolean)) throw new EolIllegalReturnException("Boolean", value, this.guardAst, context);
            guardSatisfied = (Boolean)value;
        }
        if (!appliesToTypes) return false;
        if (!guardSatisfied) return false;
        return true;
    }

    public Collection<?> getAllOfRightType(IEmlContext context) throws EolRuntimeException {
        if (this.allOfRightType == null) {
            try {
                EolModelElementType rightType = (EolModelElementType)this.rightParameter.getType(context);
                this.allOfRightType = rightType.getAllOfType();
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
            catch (EolModelNotFoundException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfRightType;
    }

    public Collection<?> getAllOfLeftType(IEmlContext context) throws EolRuntimeException {
        if (this.allOfLeftType == null) {
            try {
                EolModelElementType leftType = (EolModelElementType)this.leftParameter.getType(context);
                this.allOfLeftType = leftType.getAllOfType();
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
            catch (EolModelNotFoundException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfLeftType;
    }

    public Collection<?> getAllOfRightKind(IEmlContext context) throws EolRuntimeException {
        if (this.allOfRightKind == null) {
            try {
                EolModelElementType rightType = (EolModelElementType)this.rightParameter.getType(context);
                this.allOfRightKind = rightType.getAllOfKind();
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
            catch (EolModelNotFoundException ex) {
                ex.setAst(this.rightParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfRightKind;
    }

    public Collection<?> getAllOfLeftKind(IEmlContext context) throws EolRuntimeException {
        if (this.allOfLeftKind == null) {
            try {
                EolModelElementType leftType = (EolModelElementType)this.leftParameter.getType(context);
                this.allOfLeftKind = leftType.getAllOfKind();
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
            catch (EolModelNotFoundException ex) {
                ex.setAst(this.leftParameter.getTypeAst());
                throw ex;
            }
        }
        return this.allOfLeftKind;
    }

    public Collection<?> merge(Match match, Collection<Object> targets, IEmlContext context) throws EolRuntimeException {
        MergeTrace mergeTrace = context.getMergeTrace();
        Merges merges = mergeTrace.getMerges(match, this);
        if (!merges.isEmpty()) {
            return merges.getTargets();
        }
        this.executeSuperRulesAndBody(match, targets, context);
        return targets;
    }

    public boolean hasMerged(Match match) {
        return this.mergedMatches.contains(match);
    }

    public Collection<?> merge(Match match, IEmlContext context) throws EolRuntimeException {
        MergeTrace mergeTrace = context.getMergeTrace();
        if (this.hasMerged(match)) {
            return mergeTrace.getMerges(match, this).getTargets();
        }
        this.mergedMatches.add(match);
        Object left = match.getLeft();
        Object right = match.getRight();
        List<Object> targets = CollectionUtil.createDefaultList();
        ListIterator<EolFormalParameter> li = this.targetParameters.listIterator();
        while (li.hasNext()) {
            EolFormalParameter targetParameter = li.next();
            EolType targetParameterType = targetParameter.getType(context);
            targets.add(targetParameterType.createInstance());
        }
        mergeTrace.add(match, targets, this);
        this.executeSuperRulesAndBody(match, targets, context);
        return targets;
    }

    public String toString() {
        String str = this.name;
        str = String.valueOf(str) + " (";
        str = String.valueOf(str) + this.leftParameter.getTypeName() + ", " + this.rightParameter.getTypeName();
        str = String.valueOf(str) + ") : ";
        ListIterator<EolFormalParameter> li = this.targetParameters.listIterator();
        while (li.hasNext()) {
            EolFormalParameter targetParameter = li.next();
            str = String.valueOf(str) + targetParameter.getTypeName();
            if (!li.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return str;
    }

    public void executeSuperRulesAndBody(Match match, Collection<Object> targets, IEmlContext context) throws EolRuntimeException {
        for (MergeRule superRule : this.superRules) {
            superRule.merge(match, targets, context);
        }
        FrameStack scope = context.getFrameStack();
        scope.enterLocal(FrameType.PROTECTED, this.ast, new Variable[0]);
        scope.put(new Variable(this.leftParameter.getName(), match.getLeft(), this.leftParameter.getType(context), true));
        scope.put(new Variable(this.rightParameter.getName(), match.getRight(), this.rightParameter.getType(context), true));
        scope.put(Variable.createReadOnlyVariable("self", this));
        int i = 0;
        while (i < this.targetParameters.size()) {
            EolFormalParameter targetParameter = this.targetParameters.get(i);
            scope.put(new Variable(targetParameter.getName(), CollectionUtil.asList(targets).get(i), targetParameter.getType(context), true));
            ++i;
        }
        context.getExecutorFactory().executeAST(this.bodyAst, context);
        scope.leaveLocal(this.ast);
    }

    @Override
    public AST getSuperRulesAst() {
        return AstUtil.getChild(this.ast, 78);
    }

    @Override
    public List<?> getChildren() {
        return Collections.emptyList();
    }
}

