/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolBreakException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolContinueException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class ForStatementExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        AST iteratorAst = ast.getFirstChild();
        AST iteratedCollectionAst = ast.getFirstChild().getNextSibling();
        AST bodyAst = iteratedCollectionAst.getNextSibling();
        Object iterated = context.getExecutorFactory().executeAST(iteratedCollectionAst, context);
        List iteratedCol = null;
        if (iterated instanceof Collection) {
            iteratedCol = (List)iterated;
        } else if (iterated instanceof Iterable) {
            iteratedCol = CollectionUtil.iterate((Iterable)iterated);
        } else if (iterated instanceof EolModelElementType) {
            iteratedCol = CollectionUtil.createDefaultList();
            iteratedCol.addAll(((EolModelElementType)iterated).all());
        } else {
            iteratedCol = CollectionUtil.createDefaultList();
            iteratedCol.add(iterated);
        }
        String iteratorName = "";
        EolType iteratorType = null;
        iteratorName = iteratorAst.getFirstChild().getText();
        AST iteratorTypeAst = iteratorAst.getFirstChild().getNextSibling();
        iteratorType = iteratorTypeAst != null ? (EolType)context.getExecutorFactory().executeAST(iteratorTypeAst, context) : EolAnyType.Instance;
        Iterator li = iteratedCol.iterator();
        if (iteratorType != EolAnyType.Instance) {
            List typeSafeCollection = CollectionUtil.createDefaultList();
            while (li.hasNext()) {
                Object next = li.next();
                if (!iteratorType.isKind(next)) continue;
                typeSafeCollection.add(next);
            }
            li = typeSafeCollection.iterator();
        }
        boolean loopBroken = false;
        int loop = 1;
        while (li.hasNext() && !loopBroken) {
            Object next = li.next();
            if (!iteratorType.isKind(next)) continue;
            context.getFrameStack().enterLocal(FrameType.UNPROTECTED, ast, new Variable[0]);
            context.getFrameStack().put(new Variable(iteratorName, next, iteratorType));
            context.getFrameStack().put(new Variable("hasMore", li.hasNext(), EolPrimitiveType.Boolean, true));
            context.getFrameStack().put(new Variable("loopCount", loop++, EolPrimitiveType.Integer, true));
            Object result = null;
            try {
                result = context.getExecutorFactory().executeAST(bodyAst, context, true);
                context.getFrameStack().leaveLocal(ast);
            }
            catch (EolBreakException ex) {
                loopBroken = true;
                context.getFrameStack().leaveLocal(ast);
                if (ex.isBreaksAll() && context.getFrameStack().isInLoop()) {
                    throw ex;
                }
            }
            catch (EolContinueException cex) {
                context.getFrameStack().leaveLocal(ast);
            }
            if (!(result instanceof Return)) continue;
            return result;
        }
        return null;
    }
}

