/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.declarative.IteratorOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectBasedOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.AbstractSimpleOperation;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolAnyType;

public class PointExecutor
extends AbstractExecutor {
    public Object execute(AST ast, IEolContext context, boolean returnSetter) throws EolRuntimeException {
        AST objectAst = ast.getFirstChild();
        AST featureCallAst = objectAst.getNextSibling();
        Object source = context.getExecutorFactory().executeAST(objectAst, context);
        return this.execute(source, featureCallAst, context, returnSetter);
    }

    protected boolean isArrow() {
        return false;
    }

    public Object execute(Object source, AST featureCallAst, IEolContext context, boolean returnSetter) throws EolRuntimeException {
        AST parametersAst = featureCallAst.getFirstChild();
        if (parametersAst == null) {
            String propertyName = featureCallAst.getText();
            if (source == null) {
                throw new EolRuntimeException("Called feature " + propertyName + " on undefined object", featureCallAst);
            }
            if (returnSetter) {
                IPropertySetter setter = context.getIntrospectionManager().getPropertySetterFor(source, propertyName, context);
                setter.setAst(featureCallAst);
                return setter;
            }
            IPropertyGetter getter = context.getIntrospectionManager().getPropertyGetterFor(source, propertyName, context);
            if (source instanceof Collection && !getter.hasProperty(source, propertyName)) {
                IteratorOperation collectOperation = (IteratorOperation)this.getAbstractOperation(source, "collect", featureCallAst, context.getModelRepository().getOwningModel(source), context);
                AST expressionAst = new AST((Token)new CommonToken(9, "."), featureCallAst);
                expressionAst.addChild(new AST((Token)new CommonToken(19, "_iterator"), featureCallAst));
                expressionAst.addChild(new AST((Token)new CommonToken(19, propertyName), featureCallAst));
                return collectOperation.execute(source, new Variable("_iterator", null, EolAnyType.Instance), expressionAst, context);
            }
            getter.setAst(featureCallAst);
            return this.wrap(getter.invoke(source, propertyName));
        }
        return this.executeOperation(context, source, featureCallAst);
    }

    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        return this.execute(ast, context, false);
    }

    public Object executeOperation(IEolContext context, Object target, AST featureCallAst) throws EolRuntimeException {
        EolOperation helper;
        AST parametersAst = featureCallAst.getFirstChild();
        String operationName = featureCallAst.getText();
        IModel owningModel = context.getModelRepository().getOwningModel(target);
        if (parametersAst.getType() == 25) {
            AbstractOperation operation = this.getAbstractOperation(target, operationName, featureCallAst, owningModel, context);
            if (operation instanceof SelectBasedOperation) {
                ((SelectBasedOperation)operation).setSelectOperation((SelectOperation)this.getAbstractOperation(target, "select", featureCallAst, owningModel, context));
            }
            return operation.execute(target, featureCallAst, context);
        }
        AbstractOperation operation = context.getOperationFactory().getOperationFor(operationName);
        if (operation != null && !operation.isOverridable()) {
            return operation.execute(target, featureCallAst, context);
        }
        OperationContributor modelOperationContributor = null;
        if (owningModel != null && owningModel instanceof IOperationContributorProvider) {
            modelOperationContributor = ((IOperationContributorProvider)((Object)owningModel)).getOperationContributor();
        }
        ObjectMethod objectMethodAst = null;
        if (modelOperationContributor != null) {
            objectMethodAst = modelOperationContributor.findContributedMethodForUnevaluatedParameters(target, operationName, context);
        }
        if (objectMethodAst == null) {
            objectMethodAst = context.getOperationContributorRegistry().findContributedMethodForUnevaluatedParameters(target, operationName, context);
        }
        if (objectMethodAst != null) {
            return this.wrap(objectMethodAst.execute(new Object[]{featureCallAst}, featureCallAst));
        }
        ArrayList parameters = (ArrayList)context.getExecutorFactory().executeAST(parametersAst, context);
        if (context.getModule() instanceof IEolLibraryModule && !this.isArrow() && (helper = ((IEolLibraryModule)context.getModule()).getOperations().getOperation(target, featureCallAst, parameters, context)) != null) {
            return ((IEolLibraryModule)context.getModule()).getOperations().execute(target, helper, featureCallAst, parameters, context);
        }
        ObjectMethod objectMethod = null;
        if (modelOperationContributor != null) {
            objectMethod = modelOperationContributor.findContributedMethodForEvaluatedParameters(target, operationName, parameters.toArray(), context);
        }
        if (objectMethod == null) {
            objectMethod = context.getOperationContributorRegistry().findContributedMethodForEvaluatedParameters(target, operationName, parameters.toArray(), context);
        }
        if (objectMethod != null) {
            return this.wrap(objectMethod.execute(parameters.toArray(), featureCallAst));
        }
        if (operation != null) {
            if (operation instanceof AbstractSimpleOperation) {
                return ((AbstractSimpleOperation)operation).execute(target, parameters, context, featureCallAst);
            }
            return operation.execute(target, featureCallAst, context);
        }
        throw new EolIllegalOperationException(target, operationName, featureCallAst, context.getPrettyPrinterManager());
    }

    protected AbstractOperation getAbstractOperation(Object target, String name, AST featureCallAst, IModel owningModel, IEolContext context) throws EolIllegalOperationException {
        AbstractOperation operation;
        IAbstractOperationContributor contributor;
        AbstractOperation operation2;
        if (target instanceof IAbstractOperationContributor && (operation2 = ((IAbstractOperationContributor)target).getAbstractOperation(name)) != null) {
            return operation2;
        }
        if (owningModel != null && owningModel instanceof IAbstractOperationContributorProvider && (contributor = ((IAbstractOperationContributorProvider)((Object)owningModel)).getAbstractOperationContributor(target)) != null && (operation = contributor.getAbstractOperation(name)) != null) {
            return operation;
        }
        operation2 = context.getOperationFactory().getOperationFor(name);
        if (operation2 != null) {
            return operation2;
        }
        throw new EolIllegalOperationException(target, name, featureCallAst, context.getPrettyPrinterManager());
    }

    public Object wrap(Object o) {
        if (o instanceof Object[]) {
            return new ArrayList<Object>(Arrays.asList((Object[])o));
        }
        return o;
    }
}

