/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolBreakException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolContinueException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class WhileStatementExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        block8: {
            Object result;
            AST conditionAst = ast.getFirstChild();
            AST bodyAst = conditionAst.getNextSibling();
            int loop = 0;
            while (true) {
                block7: {
                    context.getFrameStack().enterLocal(FrameType.UNPROTECTED, ast, new Variable[0]);
                    ++loop;
                    Object condition = context.getExecutorFactory().executeAST(conditionAst, context);
                    if (!(condition instanceof Boolean)) {
                        context.getFrameStack().leaveLocal(ast);
                        throw new EolIllegalReturnException("Boolean", condition, conditionAst, context);
                    }
                    result = null;
                    if (((Boolean)condition).booleanValue()) {
                        context.getFrameStack().put(Variable.createReadOnlyVariable("loopCount", loop));
                        try {
                            result = context.getExecutorFactory().executeAST(bodyAst, context, true);
                            break block7;
                        }
                        catch (EolBreakException bex) {
                            if (bex.isBreaksAll() && context.getFrameStack().isInLoop()) {
                                throw bex;
                            }
                            context.getFrameStack().leaveLocal(ast);
                            break block8;
                        }
                        catch (EolContinueException cex) {
                            context.getFrameStack().leaveLocal(ast);
                            continue;
                        }
                    }
                    context.getFrameStack().leaveLocal(ast);
                    break block8;
                }
                context.getFrameStack().leaveLocal(ast);
                if (result instanceof Return) break;
            }
            return result;
        }
        return null;
    }
}

