/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.DeprecationInfo;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.AsyncStatement;
import org.eclipse.epsilon.eol.execute.context.ExtendedProperties;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IntrospectionManager;
import org.eclipse.epsilon.eol.execute.operations.OperationFactory;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.epsilon.eol.userinput.JavaConsoleUserInput;

public class EolContext
implements IEolContext {
    protected IUserInput userInput = new JavaConsoleUserInput();
    protected FrameStack frameStack = new FrameStack();
    protected ModelRepository modelRepository = new ModelRepository();
    protected IntrospectionManager introspectionManager = new IntrospectionManager();
    protected ExecutorFactory executorFactory = new ExecutorFactory();
    protected OperationFactory operationFactory = new OperationFactory();
    protected PrettyPrinterManager prettyPrinterManager = new PrettyPrinterManager();
    protected PrintStream outputStream = System.out;
    protected PrintStream errorStream = System.err;
    protected IModule module = null;
    protected boolean profilingEnabled = false;
    protected boolean assertionsEnabled = true;
    protected ExtendedProperties extendedProperties = new ExtendedProperties();
    protected List<AsyncStatement> asyncStatementsQueque = new ArrayList<AsyncStatement>();
    protected PrintStream warningStream = System.out;
    protected OperationContributorRegistry methodContributorRegistry = new OperationContributorRegistry();
    protected EolClasspathNativeTypeDelegate classpathNativeTypeDelegate;
    protected List<IToolNativeTypeDelegate> nativeTypeDelegates;

    public EolContext() {
        this(new EolClasspathNativeTypeDelegate());
    }

    protected EolContext(EolClasspathNativeTypeDelegate classpathNativeTypeDelegate) {
        this.classpathNativeTypeDelegate = classpathNativeTypeDelegate;
        this.nativeTypeDelegates = new ArrayList<IToolNativeTypeDelegate>((ArrayList)CollectionUtil.asCollection(classpathNativeTypeDelegate));
    }

    @Override
    public OperationContributorRegistry getOperationContributorRegistry() {
        return this.methodContributorRegistry;
    }

    @Override
    public PrintStream getWarningStream() {
        return this.warningStream;
    }

    @Override
    public void setWarningStream(PrintStream warningStream) {
        this.warningStream = warningStream;
    }

    @Override
    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    @Override
    public void setAssertionsEnabled(boolean assertionsEnabled) {
        this.assertionsEnabled = assertionsEnabled;
    }

    @Override
    public PrettyPrinterManager getPrettyPrinterManager() {
        return this.prettyPrinterManager;
    }

    @Override
    public void setPrettyPrinterManager(PrettyPrinterManager prettyPrinterManager) {
        this.prettyPrinterManager = prettyPrinterManager;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void setOperationFactory(OperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }

    @Override
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    @Override
    public void setFrameStack(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    @Override
    public IntrospectionManager getIntrospectionManager() {
        return this.introspectionManager;
    }

    @Override
    public void setIntrospectionManager(IntrospectionManager introspectionManager) {
        this.introspectionManager = introspectionManager;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    @Override
    public void setModule(IModule module) {
        this.module = module;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public void setUserInput(IUserInput userInput) {
        String userInputVarName = "UserInput";
        this.userInput = userInput;
        Variable var = this.frameStack.get(userInputVarName);
        if (var == null) {
            var = Variable.createReadOnlyVariable(userInputVarName, userInput);
            DeprecationInfo deprecationInfo = new DeprecationInfo();
            deprecationInfo.setMessage("Variable UserInput is deprecated. Use System.user instead.");
            var.setDeprecationInfo(deprecationInfo);
            this.frameStack.putGlobal(var);
        } else {
            var.setValueBruteForce(userInput);
        }
    }

    @Override
    public IUserInput getUserInput() {
        return this.userInput;
    }

    @Override
    public List<IToolNativeTypeDelegate> getNativeTypeDelegates() {
        return this.nativeTypeDelegates;
    }

    @Override
    public void setNativeTypeDelegates(List<IToolNativeTypeDelegate> nativeTypeDelegates) {
        this.nativeTypeDelegates = nativeTypeDelegates;
    }

    @Override
    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    @Override
    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void setExtendedProperties(ExtendedProperties extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    @Override
    public void dispose() {
        if (this.executorFactory.getExecutionController() != null) {
            this.executorFactory.getExecutionController().dispose();
        }
        this.extendedProperties.clear();
    }

    @Override
    public List<AsyncStatement> getAsyncStatementsQueque() {
        return this.asyncStatementsQueque;
    }
}

