/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.execute.context.Variable;

class FrameStackRegion {
    private Deque<SingleFrame> frames = new ArrayDeque<SingleFrame>();

    FrameStackRegion() {
    }

    public void clear() {
        for (Frame frame : this.frames) {
            frame.clear();
        }
    }

    public void dispose() {
        while (!this.isEmpty()) {
            this.disposeTopFrame();
        }
    }

    public Frame enter(FrameType type, AST entryPoint, Variable ... variables) {
        this.frames.push(new SingleFrame(type, entryPoint));
        this.put(variables);
        return this.top();
    }

    public int frameCount() {
        return this.frames.size();
    }

    public Variable get(String name) {
        for (Frame frame : this.frames) {
            if (frame.contains(name)) {
                return frame.get(name);
            }
            if (frame.getType() == FrameType.PROTECTED) break;
        }
        return null;
    }

    public Map<String, Variable> getAll() {
        HashMap<String, Variable> all = new HashMap<String, Variable>();
        for (Frame frame : this.frames) {
            for (Map.Entry<String, Variable> e : frame.getAll().entrySet()) {
                if (all.containsKey(e.getKey())) continue;
                all.put(e.getKey(), e.getValue());
            }
            if (frame.getType() == FrameType.PROTECTED) break;
        }
        return all;
    }

    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    public boolean isInLoop() {
        for (SingleFrame frame : this.frames) {
            if (this.isLoopAst(frame.getEntryPoint())) {
                return true;
            }
            if (frame.getType() != FrameType.PROTECTED) continue;
            return false;
        }
        return false;
    }

    public void leave(AST entryPoint) {
        this.leave(entryPoint, true);
    }

    public void leave(AST entryPoint, boolean disposeFrameWithSpecifiedEntryPoint) {
        if (!this.isEmpty()) {
            this.disposeFramesUntil(entryPoint);
            if (disposeFrameWithSpecifiedEntryPoint) {
                this.disposeTopFrame();
            }
        }
    }

    public void put(String name, Object value) {
        this.top().put(name, value);
    }

    public void put(Variable ... variables) {
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.put(variable);
            ++n2;
        }
    }

    public void put(Variable variable) {
        this.top().put(variable);
    }

    public void putAll(Map<String, Variable> variables) {
        this.top().putAll(variables);
    }

    public void remove(String name) {
        for (Frame frame : this.frames) {
            frame.remove(name);
            if (frame.getType() == FrameType.PROTECTED) break;
        }
    }

    public Frame top() {
        return this.frames.peek();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (SingleFrame frame : this.frames) {
            result.append(frame.toString());
        }
        return result.toString();
    }

    protected FrameStackRegion clone() {
        FrameStackRegion clone = new FrameStackRegion();
        for (SingleFrame frame : this.frames) {
            clone.frames.add(frame.clone());
        }
        return clone;
    }

    protected Collection<SingleFrame> getFrames() {
        return this.frames;
    }

    protected boolean isLoopAst(AST ast) {
        return ast != null && (ast.getType() == 30 || ast.getType() == 33);
    }

    private void disposeFramesUntil(AST entryPoint) {
        while (this.top().getEntryPoint() != entryPoint) {
            this.disposeTopFrame();
        }
    }

    private void disposeTopFrame() {
        if (!this.frames.isEmpty()) {
            this.frames.pop().dispose();
        }
    }
}

