/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import org.eclipse.epsilon.eol.exceptions.EolIllegalVariableAssignmentException;
import org.eclipse.epsilon.eol.exceptions.EolReadOnlyVariableException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.DeprecationInfo;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolType;

public class Variable {
    protected String name = "";
    protected Object value = null;
    protected EolType type = null;
    protected boolean readOnly = false;
    protected DeprecationInfo deprecationInfo;

    public DeprecationInfo getDeprecationInfo() {
        return this.deprecationInfo;
    }

    public void setDeprecationInfo(DeprecationInfo deprecationInfo) {
        this.deprecationInfo = deprecationInfo;
    }

    public Variable() {
    }

    public Variable clone() {
        Variable clone = new Variable();
        clone.name = this.name;
        clone.value = this.value;
        clone.type = this.type;
        clone.readOnly = this.readOnly;
        return clone;
    }

    public Variable(String name, Object value, EolType type, boolean readOnly) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.readOnly = readOnly;
    }

    public void dispose() {
        this.type = null;
        this.value = null;
    }

    public Variable(String name, Object value, EolType type) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue, IEolContext context) throws EolRuntimeException {
        if (this.isReadOnly()) {
            throw new EolReadOnlyVariableException(this);
        }
        if (newValue != null && !this.getType().isKind(newValue)) {
            throw new EolIllegalVariableAssignmentException(this, this.getType(), newValue, context);
        }
        this.value = newValue;
    }

    public void setValueBruteForce(Object newValue) {
        this.value = newValue;
    }

    public void setType(EolType type) {
        this.type = type;
    }

    public EolType getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        return this.equals(this.name, other.name) && this.equals(this.value, other.value) && this.equals(this.type, other.type) && this.equals(this.readOnly, other.readOnly);
    }

    private boolean equals(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        return this.value + " " + this.type;
    }

    public static Variable createReadOnlyVariable(String name, Object value) {
        return new Variable(name, value, EolAnyType.Instance, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

