/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.java;

import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;

public class JavaPropertyGetter
extends AbstractPropertyGetter {
    @Override
    public boolean hasProperty(Object object, String property) {
        return this.getMethodFor(object, property).getMethod() != null;
    }

    protected ObjectMethod getMethodFor(Object object, String property) {
        ObjectMethod objectMethod = new ObjectMethod();
        objectMethod.setObject(object);
        OperationContributorRegistry registry = this.context.getOperationContributorRegistry();
        ObjectMethod om = registry.findContributedMethodForEvaluatedParameters(object, "get" + property, new Object[0], this.context);
        if (om != null) {
            return om;
        }
        om = registry.findContributedMethodForEvaluatedParameters(object, property, new Object[0], this.context);
        if (om != null) {
            return om;
        }
        om = registry.findContributedMethodForEvaluatedParameters(object, "is" + property, new Object[0], this.context);
        if (om != null) {
            return om;
        }
        return objectMethod;
    }

    @Override
    public Object invoke(Object object, String property) throws EolRuntimeException {
        ObjectMethod objectMethod = this.getMethodFor(object, property);
        if (objectMethod.getMethod() == null) {
            throw new EolIllegalPropertyException(object, property, this.ast, this.context);
        }
        try {
            if (!objectMethod.getMethod().isAccessible()) {
                objectMethod.getMethod().setAccessible(true);
            }
            return objectMethod.getMethod().invoke(objectMethod.getObject(), new Object[0]);
        }
        catch (Exception ex) {
            throw new EolInternalException(ex);
        }
    }
}

