/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection.java;

import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;

public class JavaPropertySetter
extends AbstractPropertySetter
implements IReflectivePropertySetter {
    protected ObjectMethod getMethodFor(Object object, String property, Object value) {
        ObjectMethod objectMethod = new ObjectMethod();
        objectMethod.setObject(object);
        OperationContributorRegistry registry = this.context.getOperationContributorRegistry();
        ObjectMethod om = registry.findContributedMethodForEvaluatedParameters(object, "set" + property, new Object[]{value}, this.context);
        if (om != null) {
            return om;
        }
        return objectMethod;
    }

    @Override
    public void invoke(Object value) throws EolRuntimeException {
        ObjectMethod objectMethod = this.getMethodFor(this.object, this.property, value);
        if (objectMethod.getMethod() == null) {
            throw new EolIllegalPropertyException(this.object, this.property, this.ast, this.context);
        }
        try {
            if (!objectMethod.getMethod().isAccessible()) {
                objectMethod.getMethod().setAccessible(true);
            }
            objectMethod.getMethod().invoke(objectMethod.getObject(), value);
        }
        catch (Exception ex) {
            throw new EolInternalException(ex);
        }
    }

    @Override
    public Object coerce(Object value) throws EolIllegalPropertyException {
        return value;
    }

    @Override
    public boolean conforms(Object value) throws EolIllegalPropertyException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

