/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.NumberUtil;
import org.eclipse.epsilon.eol.types.ObjectUtil;

public class IterableOperationContributor
extends OperationContributor {
    public IterableOperationContributor() {
    }

    public IterableOperationContributor(Iterable<?> target) {
        this.target = target;
    }

    protected Iterable<Object> getIterable() {
        return (Iterable)this.target;
    }

    protected boolean isCollection() {
        return this.target instanceof Collection;
    }

    protected Collection<Object> getCollection() {
        return (Collection)this.target;
    }

    protected boolean isList() {
        return this.target instanceof List;
    }

    protected List<?> getList() {
        return (List)this.target;
    }

    protected boolean isSet() {
        return this.target instanceof Set;
    }

    protected Set<?> getSet() {
        return (Set)this.target;
    }

    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Iterable;
    }

    public Object random() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.size();
        return this.nth(size > 0 ? new Random().nextInt(size) : 0);
    }

    public int size() {
        if (this.isCollection()) {
            return this.getCollection().size();
        }
        int size = 0;
        Iterator<Object> it = this.getIterable().iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    public Object at(int index) {
        if (this.isList()) {
            return this.getList().get(index);
        }
        Iterator<Object> it = this.getIterable().iterator();
        int i = 0;
        while (it.hasNext()) {
            Object next = it.next();
            if (i == index) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public Object removeAt(int index) {
        if (this.isList()) {
            return this.getList().remove(index);
        }
        Object toRemove = null;
        Iterator<Object> it = this.getIterable().iterator();
        int i = 0;
        while (it.hasNext() && i <= index) {
            toRemove = it.next();
            ++i;
        }
        if (toRemove != null && i == index + 1) {
            it.remove();
        }
        return toRemove;
    }

    public List<Object> asSequence() {
        EolSequence<Object> copy = new EolSequence<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolSet<Object> asSet() {
        EolSet<Object> copy = new EolSet<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolBag<Object> asBag() {
        EolBag<Object> copy = new EolBag<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public EolOrderedSet<Object> asOrderedSet() {
        EolOrderedSet<Object> copy = new EolOrderedSet<Object>();
        this.copy(this.getIterable(), copy);
        return copy;
    }

    public Number sum() {
        Number sum = 0;
        for (Object next : this.getIterable()) {
            if (!(next instanceof Number)) continue;
            sum = NumberUtil.add(sum, (Number)next);
        }
        return sum;
    }

    public Number product() {
        if (this.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        Number product = 1;
        for (Object next : this.getIterable()) {
            if (!(next instanceof Number)) continue;
            product = NumberUtil.multiply(product, (Number)next);
        }
        return product;
    }

    public boolean isEmpty() {
        if (this.target instanceof Collection) {
            return ((Collection)this.target).isEmpty();
        }
        return !this.getIterable().iterator().hasNext();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    protected <T> void copy(Iterable<T> source, Collection<T> target) {
        Iterator<T> it = source.iterator();
        while (it.hasNext()) {
            target.add(it.next());
        }
    }

    public Collection<?> clone() {
        if (this.isCollection()) {
            return EolCollectionType.clone(this.getCollection());
        }
        return null;
    }

    public boolean includes(Object key) {
        if (this.isCollection()) {
            return this.getCollection().contains(key);
        }
        for (Object o : this.getIterable()) {
            if (!ObjectUtil.equals(o, key)) continue;
            return true;
        }
        return false;
    }

    public boolean excludes(Object o) {
        return !this.includes(o);
    }

    public boolean includesAll(Collection<?> col) {
        for (Object item : col) {
            if (this.includes(item)) continue;
            return false;
        }
        return true;
    }

    public boolean excludesAll(Collection<?> col) {
        for (Object item : col) {
            if (!this.includes(item)) continue;
            return false;
        }
        return true;
    }

    public int count(Object o) {
        int count = 0;
        for (Object item : this.getIterable()) {
            if (!ObjectUtil.equals(item, o)) continue;
            ++count;
        }
        return count;
    }

    public Collection<Object> includingAll(Collection<Object> col) {
        Collection<Object> result = this.createCollection();
        this.addAll(this.getIterable(), result);
        this.addAll(col, result);
        return result;
    }

    public Collection<Object> including(Object o) {
        Collection<Object> result = this.createCollection();
        this.addAll(this.getIterable(), result);
        result.add(o);
        return result;
    }

    public Collection<Object> flatten() {
        Collection<Object> col = null;
        if (this.isCollection()) {
            col = this.getCollection();
        } else {
            col = this.createCollection();
            this.addAll(this.getIterable(), col);
        }
        return CollectionUtil.flatten(col);
    }

    public Collection<Object> excluding(Object o) {
        Collection<Object> excluding = this.createCollection();
        this.addAll(this.getIterable(), excluding);
        while (excluding.contains(o)) {
            excluding.remove(o);
        }
        return excluding;
    }

    public Collection<Object> excludingAll(Collection<?> col) {
        Collection<Object> difference = this.createCollection();
        for (Object next : this.getIterable()) {
            if (col.contains(next)) continue;
            difference.add(next);
        }
        return difference;
    }

    public Object first() {
        return this.nth(0);
    }

    public Object second() {
        return this.nth(1);
    }

    public Object third() {
        return this.nth(2);
    }

    public Object fourth() {
        return this.nth(3);
    }

    public Object last() {
        if (this.isCollection()) {
            return this.nth(this.getCollection().size() - 1);
        }
        Iterator<Object> it = this.getIterable().iterator();
        Object o = null;
        while (it.hasNext()) {
            o = it.next();
        }
        return o;
    }

    public int indexOf(Object o) {
        if (this.isList()) {
            return this.getList().indexOf(o);
        }
        int counter = 0;
        for (Object item : this.getIterable()) {
            if (ObjectUtil.equals(item, o)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private Object nth(int index) {
        if (this.isEmpty()) {
            return null;
        }
        return this.at(index);
    }

    public String concat() {
        return this.concat("");
    }

    public String concat(String delimiter) {
        return CollectionUtil.join(this.getIterable(), delimiter, new CollectionUtil.ElementPrinter(){

            @Override
            public String print(Object element) {
                return StringUtil.toString(element, "");
            }
        });
    }

    public Number max() {
        return this.max(0);
    }

    public Number max(Number default_) {
        Number max = null;
        for (Object next : this.getIterable()) {
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (max == null) {
                max = nextNumber;
                continue;
            }
            if (!NumberUtil.greaterThan(nextNumber, max)) continue;
            max = nextNumber;
        }
        if (max == null) {
            max = default_;
        }
        return max;
    }

    public Number min() {
        return this.min(0);
    }

    public Number min(Number default_) {
        Number min = null;
        for (Object next : this.getIterable()) {
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (min == null) {
                min = nextNumber;
                continue;
            }
            if (!NumberUtil.lessThan(nextNumber, min)) continue;
            min = nextNumber;
        }
        if (min == null) {
            min = default_;
        }
        return min;
    }

    public Collection<Object> invert() {
        EolSequence<Object> sequence = new EolSequence<Object>();
        for (Object o : this.getIterable()) {
            sequence.add(0, o);
        }
        return sequence;
    }

    public Collection<Object> createCollection() {
        if (this.isCollection()) {
            return EolCollectionType.createSameType(this.getCollection());
        }
        return new EolSequence<Object>();
    }

    public Set<Set<Object>> powerset() {
        List<Object> originalSet = this.asSequence();
        HashSet<Set<Object>> sets = new HashSet<Set<Object>>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        Object head = originalSet.get(0);
        HashSet<Object> rest = new HashSet<Object>(originalSet.subList(1, originalSet.size()));
        for (Set<Object> set : new IterableOperationContributor(rest).powerset()) {
            HashSet<Object> newSet = new HashSet<Object>();
            newSet.add(head);
            newSet.addAll(set);
            sets.add(newSet);
            sets.add(set);
        }
        return sets;
    }

    private void addAll(Iterable<Object> elements, Collection<Object> target) {
        if (elements instanceof Collection) {
            target.addAll((Collection)elements);
        } else {
            for (Object o : elements) {
                target.add(o);
            }
        }
    }
}

