/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class OperationContributor {
    protected Object target;
    protected IEolContext context;
    protected Set<String> cachedMethodNames = null;

    public abstract boolean contributesTo(Object var1);

    public ObjectMethod findContributedMethodForUnevaluatedParameters(Object target, String name, IEolContext context) {
        Method method = this.getObjectMethodFor(target, name, new Object[]{new AST()}, false);
        return this.createObjectMethod(target, method, context);
    }

    public ObjectMethod findContributedMethodForEvaluatedParameters(Object target, String name, Object[] parameters, IEolContext context) {
        Method method = this.getObjectMethodFor(target, name, parameters, true);
        return this.createObjectMethod(target, method, context);
    }

    private Method getObjectMethodFor(Object target, String name, Object[] parameters, boolean allowContravariantConversionForParameters) {
        if (this.getReflectionTarget(target) == this && this.cachedMethodNames == null) {
            this.cachedMethodNames = ReflectionUtil.getMethodNames(this, this.includeInheritedMethods());
        }
        if (this.cachedMethodNames == null || this.cachedMethodNames.contains(name)) {
            return ReflectionUtil.getMethodFor(this.getReflectionTarget(target), name, parameters, this.includeInheritedMethods(), allowContravariantConversionForParameters);
        }
        return null;
    }

    private ObjectMethod createObjectMethod(Object target, Method method, IEolContext context) {
        if (method != null) {
            ObjectMethod objectMethod = new ObjectMethod();
            this.setTarget(target);
            objectMethod.setMethod(method);
            objectMethod.setObject(this.getReflectionTarget(target));
            this.setContext(context);
            return objectMethod;
        }
        return null;
    }

    protected boolean includeInheritedMethods() {
        return false;
    }

    protected Object getReflectionTarget(Object target) {
        return this;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setContext(IEolContext context) {
        this.context = context;
    }
}

