/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class StringOperationContributor
extends OperationContributor {
    public static void main(String[] args) throws Exception {
        StringOperationContributor sop = new StringOperationContributor();
        sop.setTarget("M&S");
        System.out.println(sop.escapeXml());
    }

    @Override
    public boolean contributesTo(Object target) {
        return target instanceof String || target instanceof Character;
    }

    public Object toEnum() throws Exception {
        return this.context.getModelRepository().getEnumerationValue("" + this.target);
    }

    @Override
    public void setTarget(Object target) {
        if (target instanceof Character) {
            this.target = "" + target;
        } else {
            super.setTarget(target);
        }
    }

    public String escapeXml() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Text text = document.createTextNode("" + this.target);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(text);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, result);
        return writer.toString();
    }

    public String firstToUpperCase() {
        String value = (String)this.target;
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1, value.length());
    }

    public String firstToLowerCase() {
        String value = (String)this.target;
        return String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1, value.length());
    }

    public String ftuc() {
        return this.firstToUpperCase();
    }

    public String ftlc() {
        return this.firstToLowerCase();
    }

    public void store(String where) throws Exception {
        String value = (String)this.target;
        FileOutputStream fos = new FileOutputStream(where);
        fos.write(value.getBytes());
        fos.flush();
        fos.close();
    }

    public boolean isSubstringOf(String str) {
        String value = (String)this.target;
        return str == null ? false : str.indexOf(value) > -1;
    }

    public List<String> toCharSequence() {
        String value = (String)this.target;
        List<String> charSeq = CollectionUtil.createDefaultList();
        int i = 0;
        while (i < value.length()) {
            charSeq.add(String.valueOf(value.charAt(i)));
            ++i;
        }
        return charSeq;
    }

    public String pad(int width, String padding, boolean right) {
        String result = (String)this.target;
        int pad = width - result.length();
        while (pad > 0) {
            result = right ? String.valueOf(result) + padding : String.valueOf(padding) + result;
            --pad;
        }
        return result;
    }
}

