/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.Multimap;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.Model;

public abstract class CachedModel<ModelElementType>
extends Model {
    public static final String PROPERTY_CACHED = "cached";
    protected final Collection<ModelElementType> allContentsCache = new ArrayList<ModelElementType>();
    protected boolean allContentsAreCached = false;
    protected final List<Object> cachedTypes = new ArrayList<Object>();
    protected final Multimap<Object, ModelElementType> typeCache = new Multimap();
    protected final List<Object> cachedKinds = new ArrayList<Object>();
    protected final Multimap<Object, ModelElementType> kindCache = new Multimap();
    protected boolean cachingEnabled = true;

    protected abstract Collection<? extends ModelElementType> allContentsFromModel();

    protected abstract Collection<? extends ModelElementType> getAllOfTypeFromModel(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract Collection<? extends ModelElementType> getAllOfKindFromModel(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract ModelElementType createInstanceInModel(String var1) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException;

    protected abstract void loadModel() throws EolModelLoadingException;

    protected abstract void disposeModel();

    protected abstract boolean deleteElementInModel(Object var1) throws EolRuntimeException;

    protected abstract Object getCacheKeyForType(String var1) throws EolModelElementTypeNotFoundException;

    protected abstract Collection<String> getAllTypeNamesOf(Object var1);

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public final Collection<ModelElementType> allContents() {
        if (!this.allContentsAreCached || !this.isCachingEnabled()) {
            this.allContentsCache.clear();
            this.allContentsCache.addAll(this.allContentsFromModel());
            this.allContentsAreCached = true;
        }
        return this.allContentsCache;
    }

    public final Collection<ModelElementType> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        Object key = this.getCacheKeyForType(type);
        if (!this.cachedTypes.contains(key) || !this.isCachingEnabled()) {
            this.typeCache.replaceValues(key, this.getAllOfTypeFromModel(type));
            this.cachedTypes.add(key);
        }
        return this.typeCache.get(key);
    }

    public final Collection<ModelElementType> getAllOfKind(String kind) throws EolModelElementTypeNotFoundException {
        Object key = this.getCacheKeyForType(kind);
        if (!this.cachedKinds.contains(key) || !this.isCachingEnabled()) {
            this.kindCache.replaceValues(key, this.getAllOfKindFromModel(kind));
            this.cachedKinds.add(key);
        }
        return this.kindCache.get(key);
    }

    public final ModelElementType createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        ModelElementType instance = this.createInstanceInModel(type);
        this.allContentsCache.add(instance);
        this.typeCache.put(this.getCacheKeyForType(type), instance);
        for (String kind : this.getAllTypeNamesOf(instance)) {
            this.kindCache.put(this.getCacheKeyForType(kind), instance);
        }
        return instance;
    }

    @Override
    public final void deleteElement(Object o) throws EolRuntimeException {
        if (this.deleteElementInModel(o)) {
            Object instance = o;
            this.allContentsCache.remove(instance);
            this.typeCache.remove(this.getCacheKeyForType(this.getTypeNameOf(instance)), instance);
            for (String kind : this.getAllTypeNamesOf(instance)) {
                this.kindCache.remove(this.getCacheKeyForType(kind), instance);
            }
        }
    }

    @Override
    public final void load() throws EolModelLoadingException {
        this.clearCache();
        this.loadModel();
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        this.setCachingEnabled(new Boolean(properties.getProperty(PROPERTY_CACHED)));
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.clearCache();
        this.disposeModel();
    }

    public void clearCache() {
        this.allContentsCache.clear();
        this.allContentsAreCached = false;
        this.typeCache.clear();
        this.cachedTypes.clear();
        this.kindCache.clear();
        this.cachedKinds.clear();
    }
}

