/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.epl.Pattern;
import org.eclipse.epsilon.epl.PatternMatchModel;
import org.eclipse.epsilon.epl.PatternMatcher;
import org.eclipse.epsilon.epl.parse.EplLexer;
import org.eclipse.epsilon.epl.parse.EplParser;
import org.eclipse.epsilon.erl.ErlModule;

public class EplModule
extends ErlModule
implements IEolExecutableModule {
    protected List<Pattern> declaredPatterns = new ArrayList<Pattern>();
    protected IEolContext context;
    protected boolean repeatWhileMatchesFound = false;
    protected int maxLoops = -1;
    protected String patternMatchModelName = "P";
    public static final int INFINITE = -1;
    protected ArrayList<Pattern> patterns = null;

    public EplModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EplLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EplParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "eplModule";
    }

    @Override
    public HashMap<String, Class<?>> getImportConfiguration() {
        HashMap<String, Class<?>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("epl", EplModule.class);
        return importConfiguration;
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST patternAst : AstUtil.getChildren(this.ast, 80)) {
            this.declaredPatterns.add(new Pattern(patternAst));
        }
    }

    public List<Pattern> getDeclaredPatterns() {
        return this.declaredPatterns;
    }

    public List<Pattern> getPatterns() {
        if (this.patterns == null) {
            this.patterns = new ArrayList();
            for (EolImport import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof EplModule)) continue;
                EplModule module = (EplModule)import_.getModule();
                this.patterns.addAll(module.getPatterns());
            }
            this.patterns.addAll(this.declaredPatterns);
        }
        return this.patterns;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.getDeclaredPre());
        children.addAll(this.getDeclaredPatterns());
        children.addAll(this.getDeclaredPost());
        children.addAll(this.getDeclaredOperations());
        return children;
    }

    @Override
    public IEolContext getContext() {
        return this.context;
    }

    public void setContext(EolContext context) {
        this.context = context;
    }

    @Override
    public void reset() {
        super.reset();
        this.declaredPatterns.clear();
        this.context = new EolContext();
    }

    @Override
    public Object execute() throws EolRuntimeException {
        PatternMatchModel matchModel;
        block4: {
            this.getContext().setModule(this);
            this.execute(this.getPre(), this.context);
            PatternMatcher patternMatcher = new PatternMatcher();
            matchModel = null;
            try {
                int loops = 1;
                matchModel = patternMatcher.match(this);
                if (!this.repeatWhileMatchesFound) break block4;
                while (!matchModel.allContents().isEmpty()) {
                    if (this.maxLoops == -1 || loops != this.maxLoops) {
                        matchModel = patternMatcher.match(this);
                        ++loops;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                EolRuntimeException.propagate(ex);
            }
        }
        this.execute(this.getPost(), this.context);
        return matchModel;
    }

    public int getMaxLoops() {
        return this.maxLoops;
    }

    public void setMaxLoops(int maxLoops) {
        this.maxLoops = maxLoops;
    }

    public boolean isRepeatWhileMatches() {
        return this.repeatWhileMatchesFound;
    }

    public void setRepeatWhileMatches(boolean repeatWhileMatches) {
        this.repeatWhileMatchesFound = repeatWhileMatches;
    }

    @Override
    protected int getPreBlockTokenType() {
        return 76;
    }

    @Override
    protected int getPostBlockTokenType() {
        return 77;
    }

    public int getMaximumLevel() {
        int maximumLevel = 0;
        for (Pattern pattern : this.getPatterns()) {
            maximumLevel = Math.max(maximumLevel, pattern.getLevel());
        }
        return maximumLevel;
    }

    public String getPatternMatchModelName() {
        return this.patternMatchModelName;
    }

    public void setPatternMatchModelName(String patternMatchModelName) {
        this.patternMatchModelName = patternMatchModelName;
    }

    @Override
    public void setContext(IEolContext context) {
        this.context = context;
    }
}

