/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.epl.NoMatch;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CombinationGeneratorListener;
import org.eclipse.epsilon.epl.combinations.DynamicList;
import org.eclipse.epsilon.epl.combinations.DynamicListListener;
import org.eclipse.epsilon.epl.combinations.ListCombinationGenerator;

public class DynamicListCombinationGenerator<T>
implements CombinationGenerator<T> {
    protected int n;
    protected List<T> list = null;
    protected ListCombinationGenerator<T> listCombinationGenerator = null;
    protected ArrayList<CombinationGeneratorListener<T>> listeners = new ArrayList();
    protected boolean producedValidCombination = false;
    protected State state = State.NORMAL;
    protected Boolean optional = null;

    public void addListener(CombinationGeneratorListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CombinationGeneratorListener<T> listener) {
        this.listeners.remove(listener);
    }

    public DynamicListCombinationGenerator(List<T> list, int n) {
        this.init(list, n);
    }

    protected void init(List<T> list, int n) {
        this.list = list;
        this.n = n;
        if (list instanceof DynamicList) {
            ((DynamicList)list).addListener(new DynamicListListener<T>(){

                @Override
                public void valuesChanged(DynamicList<T> list) {
                    DynamicListCombinationGenerator.this.createCombinationGenerator();
                }
            });
        } else {
            this.createCombinationGenerator();
        }
    }

    protected void createCombinationGenerator() {
        this.listCombinationGenerator = new ListCombinationGenerator<T>(this.list, this.n);
    }

    @Override
    public void reset() {
        if (this.listCombinationGenerator != null) {
            this.listCombinationGenerator.reset();
        }
        if (this.list instanceof DynamicList) {
            ((DynamicList)this.list).reset();
        }
        for (CombinationGeneratorListener<T> listener : this.listeners) {
            listener.reset();
        }
        this.producedValidCombination = false;
        this.state = State.NORMAL;
        this.optional = null;
    }

    @Override
    public boolean hasMore() {
        if (this.state != State.NORMAL && this.isOptional()) {
            if (this.state == State.CAN_RETURN_OPTIONAL) {
                return true;
            }
            if (this.state == State.HAS_RETURNED_OPTIONAL) {
                return false;
            }
        }
        this.nudgeList();
        boolean hasMore = this.listCombinationGenerator.hasMore();
        if (!hasMore && !this.producedValidCombination && this.isOptional()) {
            this.state = State.CAN_RETURN_OPTIONAL;
            hasMore = true;
        }
        return hasMore;
    }

    @Override
    public List<T> getNext() {
        if (this.state != State.NORMAL && this.isOptional()) {
            if (this.state == State.HAS_RETURNED_OPTIONAL) {
                return null;
            }
            if (this.state == State.CAN_RETURN_OPTIONAL) {
                ArrayList<NoMatch> optional = new ArrayList<NoMatch>();
                int i = 0;
                while (i < this.n) {
                    optional.add(NoMatch.INSTANCE);
                    ++i;
                }
                this.state = State.HAS_RETURNED_OPTIONAL;
                return optional;
            }
        }
        this.nudgeList();
        List<T> next = this.listCombinationGenerator.getNext();
        for (CombinationGeneratorListener<T> listener : this.listeners) {
            listener.generated(next);
        }
        return next;
    }

    protected void nudgeList() {
        this.list.size();
    }

    @Override
    public void producedValidCombination() {
        this.producedValidCombination = true;
    }

    public boolean isOptional() {
        if (this.optional == null) {
            this.optional = this.checkOptional();
        }
        return this.optional;
    }

    public Boolean checkOptional() {
        return false;
    }

    static enum State {
        NORMAL,
        CAN_RETURN_OPTIONAL,
        HAS_RETURNED_OPTIONAL;

    }
}

