/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.erl.strategy.IEquivalentProvider;
import org.eclipse.epsilon.etl.TransformRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.strategy.ITransformationStrategy;

public class DefaultTransformationStrategy
implements ITransformationStrategy {
    protected IEquivalentProvider equivalentProvider = this;

    public List<Object> getExcluded() {
        return Collections.emptyList();
    }

    @Override
    public boolean canTransform(Object source) {
        return !this.getExcluded().contains(source);
    }

    @Override
    public Collection<?> transform(Object source, IEtlContext context, List<String> rules) throws EolRuntimeException {
        List targets = CollectionUtil.createDefaultList();
        if (!this.canTransform(source)) {
            return targets;
        }
        for (INamedRule rule : context.getModule().getTransformRules().getRulesFor(source, context)) {
            TransformRule transformRule = (TransformRule)rule;
            if (rules != null && !rules.contains(rule.getName())) continue;
            Collection<?> transformed = transformRule.transform(source, context);
            if (!transformRule.isPrimary()) {
                targets.addAll(transformed);
                continue;
            }
            int i = 0;
            for (Object target : transformed) {
                targets.add(i, target);
                ++i;
            }
        }
        return targets;
    }

    @Override
    public Collection<?> getEquivalents(Object source, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        return this.transform(source, context, rules);
    }

    @Override
    public Object getEquivalent(Object source, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        Collection<?> equivalents = this.getEquivalents(source, (IEolContext)context, rules);
        if (!equivalents.isEmpty()) {
            return CollectionUtil.getFirst(equivalents);
        }
        return null;
    }

    @Override
    public Collection<?> getEquivalent(Collection<?> collection, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        return CollectionUtil.flatten(this.getEquivalents(collection, (IEolContext)context, rules));
    }

    @Override
    public Collection<?> getEquivalents(Collection<?> collection, IEolContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        List equivalents = CollectionUtil.createDefaultList();
        for (Object item : collection) {
            Collection<?> equivalent = this.getEquivalents(item, (IEolContext)context, rules);
            if (equivalent == null || equivalents.contains(equivalent)) continue;
            equivalents.add(equivalent);
        }
        return equivalents;
    }

    @Override
    public void transformModels(IEtlContext context) throws EolRuntimeException {
        for (INamedRule rule : context.getModule().getTransformRules()) {
            TransformRule transformRule = (TransformRule)rule;
            if (transformRule.isLazy() || transformRule.isAbstract()) continue;
            transformRule.transformAll(context, this.getExcluded());
        }
    }

    @Override
    public void setEquivalentProvider(IEquivalentProvider equivalentProvider) {
        this.equivalentProvider = equivalentProvider;
    }

    @Override
    public IEquivalentProvider getEquivalentProvider() {
        return this.equivalentProvider;
    }
}

