/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eunit;

import java.util.Collections;
import java.util.Map;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class ModelBindings {
    private final Map<String, String> modelMapping;
    private final ExclusiveMode exclusiveMode;

    public ModelBindings(Map<String, String> mapping, ExclusiveMode mode) throws EolRuntimeException {
        assert (mapping != null) : "Model mapping map cannot be null";
        assert (mode != null) : "Model exclusivity mode cannot be null";
        this.modelMapping = mapping;
        this.exclusiveMode = mode;
        for (String key : this.modelMapping.keySet()) {
            String value = this.modelMapping.get(key);
            if (key instanceof String && value instanceof String) continue;
            throw new EolRuntimeException("Model bindings expect a map with String keys and values");
        }
    }

    public ExclusiveMode getExclusiveMode() {
        return this.exclusiveMode;
    }

    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.modelMapping);
    }

    public String toString() {
        return "ModelBindings [modelMapping=" + this.modelMapping + ", exclusiveMode=" + (Object)((Object)this.exclusiveMode) + "]";
    }

    public static enum ExclusiveMode {
        INCLUDE_OTHERS,
        EXCLUDE_OTHERS;

    }
}

