/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ewl;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.ewl.EwlWizard;

public class EwlWizardInstance {
    protected IEolContext context;
    protected Object self;
    protected EwlWizard wizard;
    protected FrameStack scope;

    public EwlWizardInstance(EwlWizard wizard, Object self, IEolContext context) {
        this.context = context;
        this.scope = context.getFrameStack().clone();
        this.self = self;
        this.wizard = wizard;
    }

    public EwlWizardInstance() {
    }

    public IEolContext getContext() {
        return this.context;
    }

    public void setContext(IEolContext context) {
        this.context = context;
    }

    public Object getSelf() {
        return this.self;
    }

    public void setSelf(Object self) {
        this.self = self;
    }

    public EwlWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(EwlWizard template) {
        this.wizard = template;
    }

    public void process() throws EolRuntimeException {
        FrameStack oldScope = this.context.getFrameStack();
        this.context.setFrameStack(this.scope);
        try {
            try {
                this.context.getModelRepository().getTransactionSupport().startTransaction();
                this.wizard.process(this.self, this.context);
                this.context.getModelRepository().getTransactionSupport().commitTransaction();
            }
            catch (EolRuntimeException rex) {
                this.context.getModelRepository().getTransactionSupport().rollbackTransaction();
                throw rex;
            }
        }
        finally {
            this.context.setFrameStack(oldScope);
        }
    }

    public String getTitle() throws EolRuntimeException {
        FrameStack oldScope = this.context.getFrameStack();
        this.context.setFrameStack(this.scope);
        try {
            String string = this.wizard.getTitle(this.self, this.context);
            return string;
        }
        catch (EolRuntimeException rex) {
            throw rex;
        }
        finally {
            this.context.setFrameStack(oldScope);
        }
    }
}

