/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.equivalences;

import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;

public class NoEquivalence
extends Equivalence {
    public final ModelElement original;

    public NoEquivalence(EolExecutor executor, FlockExecution execution, ModelElement original) {
        super(executor, execution);
        if (original == null) {
            throw new IllegalArgumentException("original cannot be null");
        }
        this.original = original;
    }

    @Override
    public ModelElement getOriginal() {
        return this.original;
    }

    @Override
    public void automaticallyPopulateEquivalent(ConservativeCopyContext context, IgnoredProperties ignoredProperties) throws FlockRuntimeException {
    }

    @Override
    public ModelElement getEquivalent() {
        return null;
    }

    @Override
    public void ruleApplied(FlockExecution execution) {
        execution.addWarning("Rule defined for migrating instances of " + this.original.getTypeName() + " " + "but that type cannot be instantiated in the evolved metamodel.");
    }

    @Override
    public String toString() {
        return this.original + " <-> null";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NoEquivalence)) {
            return false;
        }
        NoEquivalence other = (NoEquivalence)obj;
        return this.original.equals(other.original);
    }

    @Override
    public int hashCode() {
        return this.original.hashCode();
    }
}

