/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.execution;

import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.Guard;

public class GuardedConstructContext {
    private final ModelElement element;
    private final EolExecutor executor;

    public GuardedConstructContext(ModelElement element, EolExecutor executor) {
        this.element = element;
        this.executor = executor;
    }

    public boolean originalConformsTo(String originalType, boolean strict) {
        if (strict) {
            return this.element.isTypeOf(originalType);
        }
        return this.element.isKindOf(originalType);
    }

    public boolean originalBelongsTo(String originalPackage) {
        return this.element.belongsTo(originalPackage);
    }

    public boolean satisfies(Guard guard) throws FlockRuntimeException {
        return guard.isSatisifedBy(this.executor, this.element.createReadOnlyVariable("original"));
    }

    public boolean isContextForParentElement() {
        return this.element.getContainer() != null;
    }

    public GuardedConstructContext getContextForParentElement() {
        return new GuardedConstructContext(this.element.getContainer(), this.executor);
    }
}

