/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.common;

import java.util.LinkedList;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.execution.GuardedConstructContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.checker.PackageTypedConstructChecker;
import org.eclipse.epsilon.flock.model.domain.common.GuardedConstruct;

public abstract class PackageTypedConstruct
extends GuardedConstruct {
    private final String originalPackage;

    public PackageTypedConstruct(AST ast, AST guard, String originalPackage) {
        super(ast, new LinkedList<String>(), guard);
        if (originalPackage == null) {
            throw new IllegalArgumentException("originalPackage cannot be null");
        }
        this.originalPackage = originalPackage;
    }

    public String getOriginalPackage() {
        return this.originalPackage;
    }

    @Override
    public boolean appliesIn(GuardedConstructContext context) throws FlockRuntimeException {
        return context.originalBelongsTo(this.originalPackage) && super.appliesIn(context);
    }

    public void check(MigrationStrategyCheckingContext context) {
        new PackageTypedConstructChecker(this.originalPackage, context).check();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PackageTypedConstruct)) {
            return false;
        }
        PackageTypedConstruct other = (PackageTypedConstruct)object;
        return super.equals(other) && this.originalPackage.equals(other.originalPackage);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.originalPackage.hashCode();
    }
}

