/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.typemappings;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.FlockExecution;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.NoEquivalence;
import org.eclipse.epsilon.flock.equivalences.TypeBasedEquivalence;
import org.eclipse.epsilon.flock.execution.EolExecutor;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.PackageTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class PackageRetyping
extends PackageTypedConstruct
implements TypeMappingConstruct {
    private final String evolvedPackage;

    public PackageRetyping(AST ast, String originalPackage, String evolvedPackage, AST guard) {
        super(ast, guard, originalPackage);
        if (evolvedPackage == null) {
            throw new IllegalArgumentException("evolvedPackage cannot be null");
        }
        this.evolvedPackage = evolvedPackage;
    }

    public String getEvolvedPackage() {
        return this.evolvedPackage;
    }

    @Override
    public Equivalence createEquivalence(EolExecutor executor, FlockExecution execution, ModelElement original, EquivalenceEstablishmentContext.EquivalentFactory factory) throws FlockRuntimeException {
        String equivalentType = String.valueOf(this.evolvedPackage) + "::" + original.getUnqualifiedTypeName();
        if (factory.typeConformsToEvolvedMetamodel(equivalentType)) {
            ModelElement equivalent = factory.createModelElementInMigratedModel(equivalentType);
            return new TypeBasedEquivalence(executor, execution, original, equivalent);
        }
        return new NoEquivalence(executor, execution, original);
    }

    public String toString() {
        return "retype package " + this.getOriginalPackage() + " to " + this.evolvedPackage + " when " + this.getGuard();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PackageRetyping)) {
            return false;
        }
        PackageRetyping other = (PackageRetyping)object;
        return super.equals(object) && this.evolvedPackage.equals(other.evolvedPackage);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.evolvedPackage.hashCode();
    }
}

