/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.parse.spec;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.hutn.model.hutn.HutnFactory;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.parse.spec.HutnSpecAstToSpec;
import org.eclipse.epsilon.hutn.parse.spec.HutnSpecLexer;
import org.eclipse.epsilon.hutn.parse.spec.HutnSpecParser;

public class HutnPreamble {
    private final Collection<ParseProblem> problems = new LinkedList<ParseProblem>();
    private Token next;

    public Spec process(String hutn) {
        try {
            return this.transform(this.parse(hutn));
        }
        catch (RecognitionException ex) {
            this.addParseProblem(ex.getMessage(), ex.line, ex.charPositionInLine);
        }
        catch (Throwable ex) {
            this.addParseProblem("mismatched input: '" + this.next.getText() + "'", this.next.getLine(), this.next.getCharPositionInLine());
        }
        return this.emptySpec();
    }

    private CommonTree parse(String hutn) throws IOException, RecognitionException {
        HutnSpecLexer lexer = new HutnSpecLexer(new ANTLRReaderStream(new StringReader(hutn)));
        HutnSpecParser parser = new HutnSpecParser(new CommonTokenStream(lexer));
        this.next = parser.input.LT(1);
        return (CommonTree)parser.preamble().getTree();
    }

    private Spec transform(CommonTree ast) {
        return new HutnSpecAstToSpec(ast).transformPreamble();
    }

    private Spec emptySpec() {
        return HutnFactory.eINSTANCE.createSpec();
    }

    private void addParseProblem(String reason, int line, int column) {
        this.problems.add(new ParseProblem(line, column, reason));
    }
}

