/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.unparser.internal;

import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ReferenceSlot;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.unparser.internal.ClassObjectUnparser;
import org.eclipse.epsilon.hutn.unparser.internal.Unparser;

class SlotUnparser
extends Unparser {
    private final Slot<?> slot;

    public SlotUnparser(Slot<?> slot) {
        this.slot = slot;
    }

    public SlotUnparser(Slot<?> slot, StringBuilder builder) {
        super(builder);
        this.slot = slot;
    }

    @Override
    public void doUnparse() {
        this.unparseFeature();
        this.unparseValues();
    }

    private void unparseFeature() {
        this.builder.append(this.slot.getFeature());
        this.builder.append(": ");
    }

    private void unparseValues() {
        int index = 0;
        while (index < this.slot.getValues().size()) {
            Object value = this.slot.getValues().get(index);
            if (this.slot instanceof ReferenceSlot) {
                ClassObject co = (ClassObject)((ReferenceSlot)this.slot).getClassObjects().get(index);
                if (co == null) {
                    this.appendSignature("UnknownType", (String)value);
                } else {
                    this.appendSignature(co);
                }
            } else {
                this.unparseValue(value);
            }
            if (SlotUnparser.hasNext(this.slot.getValues(), index)) {
                this.builder.append(", ");
            }
            ++index;
        }
    }

    private static boolean hasNext(List<?> list, int currentIndex) {
        return currentIndex + 1 < list.size();
    }

    private void unparseValue(Object value) {
        if (value == null) {
            this.builder.append("null");
        } else if (value instanceof String) {
            this.unparseValue((String)value);
        } else if (value instanceof Integer || value instanceof Long || value instanceof Short | value instanceof Byte || value instanceof Float || value instanceof Double || value instanceof Boolean) {
            this.builder.append(value);
        } else if (value instanceof EEnumLiteral) {
            this.unparseValue((EEnumLiteral)value);
        } else if (value instanceof ClassObject) {
            this.unparseValue((ClassObject)value);
        } else {
            throw new IllegalStateException("Cannot unparse instances of " + value.getClass().getCanonicalName() + ": " + value);
        }
    }

    private void unparseValue(String value) {
        this.appendStringValue(this.escape(value));
    }

    private String escape(String value) {
        String escaped = value;
        escaped = escaped.replaceAll("\\\\", "\\\\\\\\");
        escaped = escaped.replaceAll("\\\"", "\\\\\"");
        return escaped;
    }

    private void unparseValue(EEnumLiteral value) {
        this.builder.append(value.getLiteral());
    }

    private void unparseValue(ClassObject value) {
        new ClassObjectUnparser(value, this.builder).unparse();
    }
}

