/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.validation;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.hutn.exceptions.HutnValidationException;
import org.eclipse.epsilon.hutn.util.EpsilonUtil;
import org.eclipse.epsilon.hutn.validation.AbstractFixer;

public abstract class AbstractValidator {
    private final AbstractFixer fixer;
    private final URL evlSource;

    protected AbstractValidator(AbstractFixer fixer, URL url) {
        this.fixer = fixer;
        this.evlSource = url;
    }

    protected List<ParseProblem> validate(IModel model, List<IModel> extraModels) throws HutnValidationException {
        return this.validate(model, extraModels.toArray(new IModel[0]));
    }

    protected List<ParseProblem> validate(IModel model, IModel ... extraModels) throws HutnValidationException {
        List<ParseProblem> problems;
        do {
            this.fixer.reset();
            problems = this.doValidate(model, extraModels);
        } while (this.fixer.hasChangedModel());
        return problems;
    }

    private List<ParseProblem> doValidate(IModel model, IModel ... extraModels) throws HutnValidationException {
        try {
            IEvlModule validator = EpsilonUtil.initialseEvlModule(this.fixer, model, extraModels);
            validator.parse(this.evlSource.toURI());
            validator.execute();
            return this.collectParseProblems(validator);
        }
        catch (Exception e) {
            throw new HutnValidationException(e);
        }
    }

    private List<ParseProblem> collectParseProblems(IEvlModule validator) {
        LinkedList<ParseProblem> problems = new LinkedList<ParseProblem>();
        if (validator != null) {
            for (EvlUnsatisfiedConstraint constraint : validator.getContext().getUnsatisfiedConstraints()) {
                problems.add(this.fixer.interpretUnsatisfiedConstraint(constraint));
            }
        }
        return problems;
    }
}

