/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.validation.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ModelElement;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.validation.AbstractFixer;

class HutnFixer
extends AbstractFixer {
    HutnFixer() {
    }

    @Override
    protected ParseProblem interpretUnsatisfiedConstraint(EvlUnsatisfiedConstraint constraint) {
        if (constraint.getInstance() instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)constraint.getInstance();
            return new ParseProblem(modelElement.getLine(), modelElement.getCol(), constraint.getMessage());
        }
        throw new IllegalArgumentException("Constraint instance was not a ModelElement");
    }

    @Override
    protected boolean applyFix(EvlUnsatisfiedConstraint constraint) throws EolRuntimeException {
        return this.applyFixForClassMustSpecifyRequiredReferences(constraint);
    }

    private boolean applyFixForClassMustSpecifyRequiredReferences(EvlUnsatisfiedConstraint constraint) throws EolRuntimeException {
        ClassObject object = (ClassObject)constraint.getInstance();
        List<Slot<?>> originalSlots = HutnFixer.defensiveCopy(object.getSlots());
        constraint.getFixes().get(0).perform();
        return !originalSlots.equals(object.getSlots());
    }

    private static <T> List<T> defensiveCopy(List<T> original) {
        return new LinkedList<T>(original);
    }
}

