/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.parser.sax;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ContentHandlerMultiplexer
implements ContentHandler {
    private final List<ContentHandler> handlers = new LinkedList<ContentHandler>();

    public ContentHandlerMultiplexer(ContentHandler ... handlers) {
        this.handlers.addAll(Arrays.asList(handlers));
    }

    @Override
    public void startDocument() throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.endDocument();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        for (ContentHandler handler : this.handlers) {
            handler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        for (ContentHandler handler : this.handlers) {
            handler.skippedEntity(name);
        }
    }
}

