/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.postprocessor;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ContainmentSlot;
import org.eclipse.epsilon.hutn.model.hutn.PackageObject;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.xmi.util.StringUtil;

public class UriFragmentResolver {
    private Spec spec;

    public UriFragmentResolver(Spec spec) {
        this.spec = spec;
    }

    public static boolean isUriFragment(String value) {
        return UriFragmentResolver.isSingleUriFragment(value) || UriFragmentResolver.isManyUriFragments(value);
    }

    public static boolean isSingleUriFragment(String value) {
        return value.startsWith("/") || value.startsWith("#/");
    }

    public static boolean isManyUriFragments(String value) {
        String[] stringArray = value.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String potentialFragment = stringArray[n2];
            if (!UriFragmentResolver.isSingleUriFragment(potentialFragment)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Collection<ClassObject> resolve(String value) {
        if (!UriFragmentResolver.isUriFragment(value)) {
            throw new IllegalArgumentException("Not a valid URI fragment: " + value);
        }
        LinkedList<ClassObject> resolved = new LinkedList<ClassObject>();
        String[] stringArray = value.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uriFragment = stringArray[n2];
            resolved.add(this.resolveUriFragment(uriFragment));
            ++n2;
        }
        return resolved;
    }

    private ClassObject resolveUriFragment(String uriFragment) {
        if (uriFragment.equals("//") || uriFragment.equals("#//")) {
            return this.getTopLevelObject(0);
        }
        List<String> segments = Arrays.asList(this.removePrefix(uriFragment).split("/"));
        int index = segments.get(0).length() == 0 ? 0 : Integer.parseInt(segments.get(0));
        return this.resolveRelativeTo(this.getTopLevelObject(index), UriFragmentResolver.tail(segments));
    }

    private String removePrefix(String uriFragment) {
        return StringUtil.removeLeading('/', StringUtil.removeLeading('#', uriFragment));
    }

    private ClassObject getTopLevelObject(int index) {
        return (ClassObject)((PackageObject)this.spec.getObjects().get(0)).getClassObjects().get(index);
    }

    private ClassObject resolveRelativeTo(ClassObject base, List<String> segments) {
        if (segments.isEmpty() || base == null) {
            return base;
        }
        return this.resolveRelativeTo(this.resolveSegment(base, segments.get(0)), UriFragmentResolver.tail(segments));
    }

    private ClassObject resolveSegment(ClassObject base, String segment) {
        if (segment.startsWith("@")) {
            int positionOfDelimiter = segment.lastIndexOf(46);
            if (positionOfDelimiter <= 1) {
                System.err.println("!!!!!!!!!! " + segment);
                return null;
            }
            String feature = segment.substring(1, positionOfDelimiter);
            int index = Integer.parseInt(segment.substring(positionOfDelimiter + 1));
            Slot<?> slot = base.findSlot(feature);
            if (!(slot instanceof ContainmentSlot)) {
                return null;
            }
            return UriFragmentResolver.getClassObject((ContainmentSlot)slot, index);
        }
        return null;
    }

    private static <T> List<T> tail(List<T> list) {
        return list.subList(1, list.size());
    }

    private static ClassObject getClassObject(ContainmentSlot slot, int index) {
        if (index < 0 || index >= slot.getClassObjects().size()) {
            return null;
        }
        return (ClassObject)slot.getClassObjects().get(index);
    }
}

