/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.util;

import java.util.Arrays;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epsilon.hutn.model.hutn.AttributeSlot;
import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.ReferenceSlot;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.xmi.util.EmfUtil;

public abstract class HutnUtil {
    private HutnUtil() {
    }

    public static EStructuralFeature determineFeatureFromMetaClass(ClassObject classObject, String featureName) {
        if (classObject.hasEClass()) {
            for (EStructuralFeature feature : classObject.getEClass().getEAllStructuralFeatures()) {
                if (!featureName.equals(feature.getName())) continue;
                return feature;
            }
        }
        return null;
    }

    public static Slot<?> determineSlotFromMetaFeature(ClassObject classObject, String featureName) {
        EStructuralFeature feature = HutnUtil.determineFeatureFromMetaClass(classObject, featureName);
        if (feature == null) {
            return null;
        }
        Slot<Object> slot = feature instanceof EReference ? (((EReference)feature).isContainment() ? classObject.findOrCreateContainmentSlot(featureName) : classObject.findOrCreateReferenceSlot(featureName)) : classObject.findOrCreateAttributeSlot(featureName);
        slot.setFeature(featureName);
        return slot;
    }

    public static void addValueToSlot(Slot<?> slot, String value) {
        if (slot instanceof AttributeSlot) {
            HutnUtil.addValueToSlot((AttributeSlot)slot, value);
        } else if (slot instanceof ReferenceSlot) {
            HutnUtil.addValueToSlot((ReferenceSlot)slot, value);
        } else {
            throw new IllegalArgumentException("slot must be of type AttributeSlot or ReferenceSlot, but was: " + slot.getClass().getCanonicalName());
        }
    }

    public static void addValueToSlot(AttributeSlot slot, String value) {
        if (slot.hasEStructuralFeature()) {
            slot.getValues().add(EmfUtil.createFromString((EDataType)slot.getEStructuralFeature().getEType(), value));
        } else {
            slot.getValues().add(value);
        }
    }

    public static void addValueToSlot(ReferenceSlot slot, String value) {
        slot.getValues().addAll(Arrays.asList(value.split(" ")));
    }
}

