/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.evl.CommandLineFixer;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.workflow.tasks.ExportableModuleTask;

public class EvlTask
extends ExportableModuleTask {
    protected String exportConstraintTrace;

    public String getExportConstraintTrace() {
        return this.exportConstraintTrace;
    }

    public void setExportConstraintTrace(String exportConstraintTrace) {
        this.exportConstraintTrace = exportConstraintTrace;
    }

    @Override
    protected IEolExecutableModule createModule() {
        return new EvlModule();
    }

    @Override
    protected void initialize() throws Exception {
        IEvlModule evlModule = (IEvlModule)this.module;
        CommandLineFixer clf = new CommandLineFixer();
        clf.setFix(false);
        evlModule.setUnsatisfiedConstraintFixer(clf);
    }

    @Override
    protected void examine() throws Exception {
        super.examine();
        IEvlModule evlModule = (IEvlModule)this.module;
        int errors = 0;
        int warnings = 0;
        for (EvlUnsatisfiedConstraint unsatisfiedConstraint : evlModule.getContext().getUnsatisfiedConstraints()) {
            if (unsatisfiedConstraint.getConstraint().isCritique()) {
                if (unsatisfiedConstraint.getConstraint().isInfo()) continue;
                ++warnings;
                continue;
            }
            ++errors;
        }
        this.log("Errors : " + errors);
        String message = String.valueOf(errors) + " error(s) and " + warnings + " warning(s) found during validation";
        if (errors > 0) {
            this.fail(message, null);
        } else if (warnings > 0) {
            this.warn(message);
        }
        if (this.exportConstraintTrace != null) {
            this.getProjectStackFrame().put(this.exportConstraintTrace, evlModule.getContext().getConstraintTrace());
        }
    }

    protected Collection<Class<?>> getClassesForExportedModel() {
        ArrayList classes = new ArrayList();
        classes.add(EvlUnsatisfiedConstraint.class);
        return classes;
    }

    protected ArrayList<Object> getObjectsForExportedModel() {
        return new ArrayList<Object>(((EvlModule)this.module).getContext().getUnsatisfiedConstraints());
    }
}

